/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoTransactionFoundException;

public final class ThreadLocalTransaction {
    public static final AtomicLong getCount = new AtomicLong();
    public static final AtomicLong setCount = new AtomicLong();
    public static final boolean STATISTICS_ENABLED = false;
    public static final ThreadLocal<Transaction> threadlocal = new ThreadLocal();

    public static void clearThreadLocalTransaction() {
        threadlocal.set(null);
    }

    public static Transaction getThreadLocalTransaction() {
        return threadlocal.get();
    }

    public static Transaction getRequiredThreadLocalTransaction() {
        Transaction t = threadlocal.get();
        if (t == null) {
            throw new NoTransactionFoundException("No transaction is found on the ThreadLocalTransaction");
        }
        return t;
    }

    public static void setThreadLocalTransaction(Transaction newTransaction) {
        threadlocal.set(newTransaction);
    }

    private ThreadLocalTransaction() {
    }
}

