/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.datastructures.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import org.multiverse.api.StmUtils;
import org.multiverse.api.annotations.AtomicMethod;
import org.multiverse.utils.TodoException;

public abstract class AbstractBlockingDeque<E>
extends AbstractCollection<E>
implements BlockingDeque<E> {
    @Override
    @AtomicMethod
    public boolean offerFirst(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @AtomicMethod
    public boolean offerLast(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @AtomicMethod
    public boolean addAll(Collection<? extends E> c) {
        return super.addAll(c);
    }

    @Override
    @AtomicMethod
    public void addFirst(E e) {
        if (this.hasNoStorageCapacity()) {
            throw new IllegalStateException();
        }
        this.doAddFirst(e);
    }

    protected abstract void doAddFirst(E var1);

    @Override
    @AtomicMethod
    public void addLast(E e) {
        if (this.hasNoStorageCapacity()) {
            throw new IllegalStateException();
        }
        this.doAddLast(e);
    }

    @Override
    @AtomicMethod
    public boolean offerFirst(E e) {
        if (this.hasNoStorageCapacity()) {
            return false;
        }
        this.doAddFirst(e);
        return true;
    }

    @Override
    @AtomicMethod
    public boolean offerLast(E e) {
        if (this.hasNoStorageCapacity()) {
            return false;
        }
        this.doAddLast(e);
        return true;
    }

    protected abstract void doAddLast(E var1);

    @Override
    @AtomicMethod
    public void putFirst(E e) throws InterruptedException {
        if (this.hasNoStorageCapacity()) {
            StmUtils.retry();
        }
        this.doAddFirst(e);
    }

    @Override
    @AtomicMethod
    public void putLast(E e) throws InterruptedException {
        if (this.hasNoStorageCapacity()) {
            StmUtils.retry();
        }
        this.doAddLast(e);
    }

    @Override
    @AtomicMethod
    public E takeFirst() throws InterruptedException {
        if (this.isEmpty()) {
            StmUtils.retry();
        }
        return this.doRemoveFirst();
    }

    protected abstract E doRemoveFirst();

    @Override
    @AtomicMethod
    public E takeLast() throws InterruptedException {
        if (this.isEmpty()) {
            StmUtils.retry();
        }
        return this.doRemoveLast();
    }

    protected abstract E doRemoveLast();

    @Override
    @AtomicMethod
    public E removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.doRemoveFirst();
    }

    @Override
    @AtomicMethod
    public E removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.doRemoveLast();
    }

    @Override
    @AtomicMethod
    public boolean removeFirstOccurrence(Object o) {
        throw new TodoException();
    }

    @Override
    @AtomicMethod
    public boolean removeLastOccurrence(Object o) {
        throw new TodoException();
    }

    @Override
    @AtomicMethod
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @AtomicMethod
    protected boolean hasNoStorageCapacity() {
        return this.remainingCapacity() == 0;
    }

    @Override
    @AtomicMethod
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    @AtomicMethod
    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    @Override
    @AtomicMethod
    public E remove() {
        return this.removeFirst();
    }

    @Override
    @AtomicMethod
    public E poll() {
        return this.pollFirst();
    }

    @Override
    @AtomicMethod
    public E pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.doRemoveFirst();
    }

    @Override
    @AtomicMethod
    public E pollLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.doRemoveLast();
    }

    @Override
    @AtomicMethod
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @AtomicMethod
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @AtomicMethod
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @AtomicMethod
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @AtomicMethod
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    @Override
    @AtomicMethod(readonly=true)
    public E element() {
        return this.getFirst();
    }

    @Override
    @AtomicMethod(readonly=true)
    public E peek() {
        return this.peekFirst();
    }

    @Override
    @AtomicMethod
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    @AtomicMethod
    public int drainTo(Collection<? super E> c) {
        for (Object item : this) {
            c.add(item);
        }
        int oldSize = this.size();
        this.clear();
        return oldSize;
    }

    @Override
    @AtomicMethod
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new TodoException();
    }

    @Override
    @AtomicMethod
    public E pop() {
        return this.removeFirst();
    }

    @Override
    @AtomicMethod(readonly=true)
    public E getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.peekFirst();
    }

    @Override
    @AtomicMethod(readonly=true)
    public E getLast() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.peekLast();
    }
}

