/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.datastructures.refs;

import org.multiverse.api.StmUtils;
import org.multiverse.api.annotations.AtomicMethod;
import org.multiverse.api.annotations.AtomicObject;
import org.multiverse.datastructures.refs.ManagedRef;

@AtomicObject
public final class AbaRef<E>
implements ManagedRef<E> {
    private E reference;
    private long writeVersion;

    public AbaRef() {
        this.reference = null;
        this.writeVersion = Long.MIN_VALUE;
    }

    public AbaRef(E reference) {
        this.reference = reference;
        this.writeVersion = Long.MIN_VALUE;
    }

    @Override
    @AtomicMethod(readonly=true)
    public E getOrAwait() {
        if (this.reference == null) {
            StmUtils.retry();
        }
        return this.reference;
    }

    @Override
    @AtomicMethod(readonly=true)
    public E get() {
        return this.reference;
    }

    @Override
    @AtomicMethod(readonly=true)
    public boolean isNull() {
        return this.reference == null;
    }

    @Override
    public E set(E newRef) {
        if (newRef != this.reference) {
            E oldRef = this.reference;
            this.reference = newRef;
            ++this.writeVersion;
            return oldRef;
        }
        return newRef;
    }

    @Override
    public E clear() {
        return this.set(null);
    }

    @AtomicMethod(readonly=true)
    public String toString() {
        if (this.reference == null) {
            return "AbaRef(ref=null)";
        }
        return String.format("AbaRef(ref=%s)", this.reference);
    }
}

