/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.datastructures.refs;

import org.multiverse.api.StmUtils;
import org.multiverse.api.annotations.AtomicMethod;
import org.multiverse.api.annotations.AtomicObject;
import org.multiverse.datastructures.refs.ManagedRef;

@AtomicObject
public final class Ref<E>
implements ManagedRef<E> {
    private E reference;

    public Ref() {
        this.reference = null;
    }

    public Ref(E reference) {
        this.reference = reference;
    }

    @Override
    @AtomicMethod(readonly=true)
    public E getOrAwait() {
        if (this.reference == null) {
            StmUtils.retry();
        }
        return this.reference;
    }

    @Override
    @AtomicMethod(readonly=true)
    public boolean isNull() {
        return this.reference == null;
    }

    @Override
    @AtomicMethod(readonly=true)
    public E get() {
        return this.reference;
    }

    @Override
    public E set(E newRef) {
        E oldRef = this.reference;
        this.reference = newRef;
        return oldRef;
    }

    @Override
    public E clear() {
        return this.set(null);
    }

    @AtomicMethod(readonly=true)
    public String toString() {
        if (this.reference == null) {
            return "Ref(ref=null)";
        }
        return String.format("Ref(ref=%s)", this.reference);
    }
}

