/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import java.text.MessageFormat;
import org.multiverse.MultiverseConstants;
import org.multiverse.api.ScheduleType;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionStatus;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.PanicError;
import org.multiverse.stms.AbstractTransactionDependencies;
import org.multiverse.utils.latches.Latch;
import org.multiverse.utils.restartbackoff.RestartBackoffPolicy;

public abstract class AbstractTransaction<D extends AbstractTransactionDependencies>
implements Transaction,
MultiverseConstants {
    protected final D dependencies;
    protected final String familyName;
    private TaskListNode scheduledTasks;
    private long version;

    public AbstractTransaction(D dependencies, String familyName) {
        assert (dependencies != null);
        this.dependencies = dependencies;
        this.familyName = familyName;
        if (SANITY_CHECKS_ENABLED && ((AbstractTransactionDependencies)dependencies).clock.getTime() == 0L) {
            throw new PanicError("Clock.time has to be larger than 0, smaller version have special meaning");
        }
    }

    @Override
    public long getReadVersion() {
        return this.version;
    }

    @Override
    public TransactionStatus getStatus() {
        if (this.version > 0L) {
            return TransactionStatus.active;
        }
        if (this.version == 0L) {
            return TransactionStatus.aborted;
        }
        return TransactionStatus.committed;
    }

    @Override
    public RestartBackoffPolicy getRestartBackoffPolicy() {
        return ((AbstractTransactionDependencies)this.dependencies).restartBackoffPolicy;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    protected final void init() {
        this.scheduledTasks = null;
        this.version = ((AbstractTransactionDependencies)this.dependencies).clock.getTime();
        this.doInit();
    }

    protected void doInit() {
    }

    @Override
    public void schedule(Runnable task, ScheduleType scheduleType) {
        switch (this.getStatus()) {
            case active: {
                if (task == null) {
                    throw new NullPointerException();
                }
                if (scheduleType == null) {
                    throw new NullPointerException();
                }
                this.scheduledTasks = new TaskListNode(task, scheduleType, this.scheduledTasks);
                break;
            }
            case committed: {
                throw new DeadTransactionException(MessageFormat.format("Can't execute compensating task on already committed transaction '%s'", this.familyName));
            }
            case aborted: {
                throw new DeadTransactionException(MessageFormat.format("Can't execute compensating task on already aborted transaction '%s'", this.familyName));
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Override
    public Transaction abortAndReturnRestarted() {
        switch (this.getStatus()) {
            case active: 
            case committed: 
            case aborted: {
                this.init();
                return this;
            }
        }
        throw new RuntimeException();
    }

    protected void excuteScheduledTasks(ScheduleType scheduleType) {
        if (this.scheduledTasks != null) {
            this.scheduledTasks.executeAll(scheduleType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        switch (this.getStatus()) {
            case active: {
                try {
                    this.excuteScheduledTasks(ScheduleType.preAbort);
                    this.version = 0L;
                    this.doAbort();
                    this.excuteScheduledTasks(ScheduleType.postAbort);
                    break;
                }
                finally {
                    this.scheduledTasks = null;
                }
            }
            case committed: {
                throw new DeadTransactionException(MessageFormat.format("Can't abort already committed transaction '%s'", this.familyName));
            }
            case aborted: {
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    protected void doAbort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long commit() {
        switch (this.getStatus()) {
            case active: {
                try {
                    this.excuteScheduledTasks(ScheduleType.preCommit);
                    boolean abort = true;
                    try {
                        long result = this.onCommit();
                        if (SANITY_CHECKS_ENABLED && result < 1L) {
                            throw new PanicError();
                        }
                        this.version = -result;
                        abort = false;
                        this.excuteScheduledTasks(ScheduleType.postCommit);
                        long l = -this.version;
                        if (abort) {
                            this.version = 0L;
                            this.doAbort();
                        }
                        return l;
                    }
                    catch (Throwable throwable) {
                        if (abort) {
                            this.version = 0L;
                            this.doAbort();
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.scheduledTasks = null;
                }
            }
            case committed: {
                return -this.version;
            }
            case aborted: {
                throw new DeadTransactionException(MessageFormat.format("Can't commit already aborted transaction '%s'", this.familyName));
            }
        }
        throw new IllegalStateException();
    }

    protected long onCommit() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortAndRegisterRetryLatch(Latch latch) {
        switch (this.getStatus()) {
            case active: {
                if (latch == null) {
                    throw new NullPointerException();
                }
                try {
                    this.doAbortAndRegisterRetryLatch(latch);
                    break;
                }
                finally {
                    this.version = 0L;
                }
            }
            case committed: {
                throw new DeadTransactionException(MessageFormat.format("Can't call abortAndRegisterRetryLatch on already committed transaction '%s'", this.familyName));
            }
            case aborted: {
                throw new DeadTransactionException(MessageFormat.format("Can't call abortAndRegisterRetryLatch on already aborted transaction '%s'", this.familyName));
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    protected void doAbortAndRegisterRetryLatch(Latch latch) {
        this.doAbort();
        throw new UnsupportedOperationException();
    }

    @Override
    public void startOr() {
        switch (this.getStatus()) {
            case active: {
                this.doStartOr();
                break;
            }
            case committed: {
                throw new DeadTransactionException(MessageFormat.format("Can't call startOr on already committed transaction '%s'", this.familyName));
            }
            case aborted: {
                throw new DeadTransactionException(MessageFormat.format("Can't call startOr on already aborted transaction '%s'", this.familyName));
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    protected void doStartOr() {
    }

    @Override
    public void endOr() {
        switch (this.getStatus()) {
            case active: {
                this.doEndOr();
                break;
            }
            case committed: {
                throw new DeadTransactionException(MessageFormat.format("Can't call endOr on already committed transaction '%s'", this.familyName));
            }
            case aborted: {
                throw new DeadTransactionException(MessageFormat.format("Can't call endOr on already aborted transaction '%s'", this.familyName));
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    protected void doEndOr() {
    }

    @Override
    public void endOrAndStartElse() {
        switch (this.getStatus()) {
            case active: {
                this.doEndOrAndStartElse();
                break;
            }
            case committed: {
                throw new DeadTransactionException(MessageFormat.format("Can't call endOrAndStartElse on already committed transaction '%s'", this.familyName));
            }
            case aborted: {
                throw new DeadTransactionException(MessageFormat.format("Can't call endOrAndStartElse on already aborted transaction '%s'", this.familyName));
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    protected void doEndOrAndStartElse() {
    }

    private static class TaskListNode {
        private final Runnable task;
        private final ScheduleType scheduleType;
        private final TaskListNode next;

        private TaskListNode(Runnable task, ScheduleType scheduleType, TaskListNode next) {
            assert (task != null);
            assert (scheduleType != null);
            this.task = task;
            this.scheduleType = scheduleType;
            this.next = next;
        }

        public void executeAll(ScheduleType requiredScheduleType) {
            assert (requiredScheduleType != null);
            TaskListNode node = this;
            do {
                if (this.scheduleType != requiredScheduleType) continue;
                node.task.run();
            } while ((node = node.next) != null);
        }
    }
}

