/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import java.util.logging.Logger;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionStatus;
import org.multiverse.api.exceptions.PanicError;
import org.multiverse.api.exceptions.RecoverableThrowable;
import org.multiverse.api.exceptions.RetryError;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.templates.AbortedException;
import org.multiverse.utils.latches.CheapLatch;

public abstract class AtomicTemplate<E> {
    private static final Logger logger = Logger.getLogger(AtomicTemplate.class.getName());
    private final Stm stm;
    private final boolean ignoreThreadLocalTransaction;
    private final int retryCount;
    private final boolean readonly;
    private int attemptCount;
    private final String familyName;

    public AtomicTemplate() {
        this(GlobalStmInstance.getGlobalStmInstance());
    }

    public AtomicTemplate(boolean readonly) {
        this(GlobalStmInstance.getGlobalStmInstance(), null, false, readonly, Integer.MAX_VALUE);
    }

    public AtomicTemplate(Stm stm) {
        this(stm, null, false, false, Integer.MAX_VALUE);
    }

    public AtomicTemplate(String familyName, boolean readonly, int retryCount) {
        this(GlobalStmInstance.getGlobalStmInstance(), familyName, false, readonly, retryCount);
    }

    public AtomicTemplate(Stm stm, String familyName, boolean ignoreThreadLocalTransaction, boolean readonly, int retryCount) {
        if (stm == null) {
            throw new NullPointerException();
        }
        if (retryCount < 0) {
            throw new IllegalArgumentException();
        }
        this.stm = stm;
        this.ignoreThreadLocalTransaction = ignoreThreadLocalTransaction;
        this.readonly = readonly;
        this.retryCount = retryCount;
        this.familyName = familyName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public final int getAttemptCount() {
        return this.attemptCount;
    }

    public final int getRetryCount() {
        return this.retryCount;
    }

    public final Stm getStm() {
        return this.stm;
    }

    public final boolean isIgnoreThreadLocalTransaction() {
        return this.ignoreThreadLocalTransaction;
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public abstract E execute(Transaction var1) throws Exception;

    protected void onInit() {
    }

    protected void postStart(Transaction t) {
    }

    protected void preCommit(Transaction t) {
    }

    protected void postCommit(long commitVersion) {
    }

    protected void postAbort(Transaction t) {
    }

    protected void onFailure() {
    }

    public final E execute() {
        try {
            return this.executeChecked();
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new InvisibleCheckedException(ex);
        }
    }

    public final E executeChecked() throws Exception {
        Transaction t = this.getTransaction();
        if (this.noActiveTransaction(t)) {
            return this.executeAtomic();
        }
        return this.execute(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E executeAtomic() throws Exception {
        this.onInit();
        Transaction t = this.startTransaction();
        this.setTransaction(t);
        this.attemptCount = 0;
        Throwable lastFailureCause = null;
        do {
            ++this.attemptCount;
            boolean error = false;
            try {
                this.postStart(t);
                E result = this.execute(t);
                this.preCommit(t);
                if (t.getStatus().equals((Object)TransactionStatus.aborted)) {
                    String msg = String.format("Transaction with familyName '%s' is aborted", t.getFamilyName());
                    throw new AbortedException(msg);
                }
                long commitVersion = t.commit();
                this.postCommit(commitVersion);
                E e = result;
                return e;
            }
            catch (Throwable throwable) {
                lastFailureCause = throwable;
                if (throwable instanceof RetryError) {
                    CheapLatch latch = new CheapLatch();
                    t.abortAndRegisterRetryLatch(latch);
                    latch.awaitUninterruptible();
                    continue;
                }
                if (throwable instanceof RecoverableThrowable) {
                    continue;
                }
                error = true;
                AtomicTemplate.rethrow(throwable);
            }
            finally {
                if (t.getStatus() == TransactionStatus.committed) {
                    t = null;
                } else if (this.attemptCount - 1 >= this.retryCount || error) {
                    if (t.getStatus() == TransactionStatus.active) {
                        t.abort();
                        this.postAbort(t);
                    }
                    t = null;
                } else {
                    t = t.abortAndReturnRestarted();
                }
                this.setTransaction(t);
            }
        } while (t != null);
        String msg = String.format("Too many retries, maximum number of retries = %s", this.retryCount);
        throw new TooManyRetriesException(msg, lastFailureCause);
    }

    private static void rethrow(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new PanicError("Unthrowable throwable", ex);
    }

    private Transaction startTransaction() {
        return this.readonly ? this.stm.startReadOnlyTransaction(this.familyName) : this.stm.startUpdateTransaction(this.familyName);
    }

    private boolean noActiveTransaction(Transaction t) {
        return t == null || t.getStatus() != TransactionStatus.active;
    }

    private Transaction getTransaction() {
        return this.ignoreThreadLocalTransaction ? null : ThreadLocalTransaction.getThreadLocalTransaction();
    }

    private void setTransaction(Transaction t) {
        if (!this.ignoreThreadLocalTransaction) {
            ThreadLocalTransaction.setThreadLocalTransaction(t);
        }
    }

    public static class InvisibleCheckedException
    extends RuntimeException {
        static final long serialVersionUID = 0L;

        public InvisibleCheckedException(Exception cause) {
            super(cause);
        }

        @Override
        public Exception getCause() {
            return (Exception)super.getCause();
        }
    }
}

