/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.clock;

import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.utils.clock.Clock;

public final class RelaxedClock
implements Clock {
    private final AtomicLong clock = new AtomicLong(0L);

    @Override
    public long tick() {
        long oldTime = this.clock.get();
        this.clock.compareAndSet(oldTime, oldTime + 1L);
        return oldTime + 1L;
    }

    @Override
    public long getTime() {
        return this.clock.get();
    }

    public String toString() {
        return String.format("RelaxedClock(time=%s)", this.clock.get());
    }
}

