/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.clock;

import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.utils.clock.Clock;

public final class StrictClock
implements Clock {
    private final AtomicLong clock = new AtomicLong();

    public StrictClock() {
    }

    public StrictClock(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        this.clock.set(time);
    }

    @Override
    public long tick() {
        return this.clock.incrementAndGet();
    }

    @Override
    public long getTime() {
        return this.clock.get();
    }

    public String toString() {
        return String.format("StrictClock(time=%s)", this.clock.get());
    }
}

