/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.commitlock;

import org.multiverse.api.Transaction;
import org.multiverse.utils.commitlock.CommitLock;
import org.multiverse.utils.commitlock.CommitLockPolicy;
import org.multiverse.utils.commitlock.CommitLockResult;
import org.multiverse.utils.commitlock.CommitLockUtils;

public final class GenericCommitLockPolicy
implements CommitLockPolicy {
    public static final CommitLockPolicy FAIL_FAST = new GenericCommitLockPolicy(0, 0);
    public static final CommitLockPolicy FAIL_FAST_BUT_RETRY = new GenericCommitLockPolicy(0, 10);
    public static final CommitLockPolicy SPIN_AND_RETRY = new GenericCommitLockPolicy(10, 10);
    private final int spinAttemptsPerLockCount;
    private final int retryCount;

    public GenericCommitLockPolicy(int spinAttemptsPerLockCount, int retryCount) {
        if (spinAttemptsPerLockCount < 0) {
            throw new IllegalArgumentException();
        }
        if (retryCount < 0) {
            throw new IllegalArgumentException();
        }
        this.spinAttemptsPerLockCount = spinAttemptsPerLockCount;
        this.retryCount = retryCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getSpinAttemptsPerLockCount() {
        return this.spinAttemptsPerLockCount;
    }

    @Override
    public CommitLockResult tryLockAndDetectConflict(CommitLock lock, Transaction lockOwner) {
        if (lockOwner == null) {
            throw new NullPointerException();
        }
        if (lock == null) {
            return CommitLockResult.success;
        }
        return lock.tryLockAndDetectConflicts(lockOwner);
    }

    @Override
    public CommitLockResult tryLockAllAndDetectConflicts(CommitLock[] locks, Transaction lockOwner) {
        if (lockOwner == null) {
            throw new NullPointerException();
        }
        if (CommitLockUtils.nothingToLock(locks)) {
            return CommitLockResult.success;
        }
        int maxAttempts = 1 + this.retryCount;
        block5: for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            switch (this.attempt(locks, lockOwner)) {
                case success: {
                    return CommitLockResult.success;
                }
                case failure: {
                    continue block5;
                }
                case conflict: {
                    return CommitLockResult.conflict;
                }
            }
            throw new IllegalStateException();
        }
        return CommitLockResult.failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommitLockResult attempt(CommitLock[] locks, Transaction lockOwner) {
        int money = 0;
        boolean locksNeedToBeReleased = true;
        int lockIndex = 0;
        try {
            for (lockIndex = 0; lockIndex < locks.length; ++lockIndex) {
                boolean lockAcquired;
                CommitLock lock = locks[lockIndex];
                if (lock == null) {
                    locksNeedToBeReleased = false;
                    CommitLockResult commitLockResult = CommitLockResult.success;
                    return commitLockResult;
                }
                block12: do {
                    switch (lock.tryLockAndDetectConflicts(lockOwner)) {
                        case success: {
                            lockAcquired = true;
                            break;
                        }
                        case failure: {
                            lockAcquired = false;
                            if (--money >= 0) continue block12;
                            --lockIndex;
                            CommitLockResult commitLockResult = CommitLockResult.failure;
                            return commitLockResult;
                        }
                        case conflict: {
                            CommitLockResult commitLockResult = CommitLockResult.conflict;
                            return commitLockResult;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                } while (!lockAcquired);
                money += this.spinAttemptsPerLockCount;
            }
            locksNeedToBeReleased = false;
            CommitLockResult commitLockResult = CommitLockResult.success;
            return commitLockResult;
        }
        finally {
            if (locksNeedToBeReleased) {
                this.releaseLocks(locks, lockOwner, lockIndex);
            }
        }
    }

    private void releaseLocks(CommitLock[] locks, Transaction owner, int lastIndexOfLockToRelease) {
        for (int k = 0; k <= lastIndexOfLockToRelease; ++k) {
            CommitLock lock = locks[k];
            lock.releaseLock(owner);
        }
    }

    public String toString() {
        return String.format("GenericCommitLockPolicy(retryCount=%s, spinAttemptsPerLockCount=%s)", this.retryCount, this.spinAttemptsPerLockCount);
    }
}

