/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.instrumentation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassUtils {
    private static final Method defineClassMethod;

    private ClassUtils() {
    }

    public static Class defineClass(ClassLoader classLoader, String className, byte[] bytecode) {
        try {
            return (Class)defineClassMethod.invoke((Object)classLoader, className.replace("/", "."), bytecode, 0, bytecode.length);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("A problem occurred while defining class '%s'", className), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(String.format("A problem occurred while defining class '%s'", className), e);
        }
    }

    public static void printClassLoaderInfo(Class clazz) {
        System.out.println(ClassUtils.getClassLoaderInfo(clazz));
    }

    public static String getClassLoaderInfo(Class clazz) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("Classloader info for class: %s\n", clazz.getName()));
        for (ClassLoader classLoader = clazz.getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            sb.append(String.format("\t%s extends %s\n", classLoader.getClass().getName(), classLoader.getClass().getSuperclass().getName()));
        }
        sb.append("\tBootstrap ClassLoader\n");
        return sb.toString();
    }

    public static void printClassLoaderInfo(ClassLoader classLoader) {
        System.out.println(ClassUtils.getClassLoaderInfo(classLoader));
    }

    public static String getClassLoaderInfo(ClassLoader classLoader) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("ClassLoader info for classLoader: %s\n", classLoader));
        while (classLoader != null) {
            sb.append(String.format("\t%s extends %s\n", classLoader.getClass().getName(), classLoader.getClass().getSuperclass().getName()));
            classLoader = classLoader.getParent();
        }
        sb.append("\tBootstrap ClassLoader\n");
        return sb.toString();
    }

    public static void printClassInfo(Class clazz) {
        System.out.println(ClassUtils.getClassInfo(clazz));
    }

    public static String getClassInfo(Class clazz) {
        StringBuffer sb = new StringBuffer();
        if (clazz.isInterface()) {
            sb.append(String.format("Info for interface: %s\n", clazz.getName()));
        } else {
            sb.append(String.format("Info for class: %s\n", clazz.getName()));
        }
        sb.append(String.format("superclass: %s\n", clazz.getSuperclass()));
        sb.append("interfaces:\n");
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            sb.append(String.format("\t%s\n", clazz2.getName()));
        }
        sb.append("fields:\n");
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            sb.append(String.format("\t%s\n", annotatedElement));
        }
        sb.append("methods");
        for (AnnotatedElement annotatedElement : clazz.getMethods()) {
            sb.append(String.format("\t%s\n", annotatedElement));
        }
        sb.append(ClassUtils.getClassLoaderInfo(clazz));
        return sb.toString();
    }

    static {
        try {
            defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClassMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

