/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.instrumentation;

import java.util.logging.Logger;

public final class InstrumentationProblemMonitor {
    private static final Logger logger = Logger.getLogger(InstrumentationProblemMonitor.class.getName());
    public static final InstrumentationProblemMonitor INSTANCE = new InstrumentationProblemMonitor();
    private volatile boolean problemFound;

    private InstrumentationProblemMonitor() {
    }

    public boolean isProblemFound() {
        return this.problemFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalProblem() {
        if (this.problemFound) {
            return;
        }
        InstrumentationProblemMonitor instrumentationProblemMonitor = this;
        synchronized (instrumentationProblemMonitor) {
            if (this.problemFound) {
                return;
            }
            this.problemFound = true;
            new LoggingDaemon().start();
        }
    }

    static class LoggingDaemon
    extends Thread {
        LoggingDaemon() {
            super("LoggingDaemon");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                logger.severe("STM integrity compromised, instrumentation problems encountered. Partial instrumented classes could give unexpected results. Check the logging for the instrumentation exception(s).");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

