/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.monitoring;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.multiverse.utils.monitoring.ProfilePublisherMBean;
import org.multiverse.utils.profiling.ProfileCollator;

public class ProfilePublisher
implements ProfilePublisherMBean {
    private static final String UNKNOWN_PROFILE_TEMPLATE = "<no profile named '%s' found>";
    private final ProfileCollator collator;

    public ProfilePublisher(ProfileCollator collator) {
        this.collator = collator;
    }

    @Override
    public String[] getProfileNames() {
        return this.collator.getProfileNames().toArray(new String[0]);
    }

    @Override
    public String getStatistics(String profileName) {
        ProfileCollator.ProfilePage page = this.collator.getProfilePage(profileName);
        return page == null ? String.format(UNKNOWN_PROFILE_TEMPLATE, profileName) : this.getStatistics(page);
    }

    private String getStatistics(ProfileCollator.ProfilePage page) {
        return page.toString();
    }

    public void writeStatisticsToStream(OutputStream stream) {
        PrintStream printStream = new PrintStream(stream);
        for (ProfileCollator.ProfilePage page : this.collator.getProfilePages()) {
            printStream.println(this.getStatistics(page));
        }
    }

    public static abstract class KeyedProfilePage<K>
    implements ProfileCollator.ProfilePage {
        private static final String NULL_VALUE_SYMBOL = "-";
        private static final int DEFAULT_VALUE_COLUMN_WIDTH = 6;
        private final String name;
        private final List<String> statLabels;
        private final Map<K, List<Long>> statistics;
        private final int valueColumnWidth;

        public KeyedProfilePage(String name, List<String> statLabels, Map<K, List<Long>> statistics) {
            this(name, statLabels, statistics, 6);
        }

        public KeyedProfilePage(String name, List<String> statLabels, Map<K, List<Long>> statistics, int valueColumnWidth) {
            this.name = name;
            this.statLabels = statLabels;
            this.statistics = statistics;
            this.valueColumnWidth = valueColumnWidth;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<Object, List<Long>> getStatistics() {
            return this.statistics;
        }

        @Override
        public List<String> getStatLabels() {
            return this.statLabels;
        }

        protected abstract String getFormattedKeyLabels();

        protected abstract String toFormattedString(K var1);

        public String toString() {
            StringBuilder stats = new StringBuilder();
            stats.append("'").append(this.name).append("'\n");
            String keyLabels = this.getFormattedKeyLabels();
            stats.append(keyLabels).append(" | ");
            int keyLabelColumnWidth = keyLabels.length();
            int headerRowWidth = keyLabelColumnWidth + 3;
            for (String statLabel : this.statLabels) {
                stats.append(String.format("%" + this.valueColumnWidth + "s ", KeyedProfilePage.truncate(statLabel, this.valueColumnWidth)));
                headerRowWidth += this.valueColumnWidth + 1;
            }
            stats.append("\n");
            for (int i = 0; i < headerRowWidth; ++i) {
                stats.append('-');
            }
            stats.append("\n");
            for (Map.Entry<K, List<Long>> statValues : this.statistics.entrySet()) {
                stats.append(this.toFormattedString(statValues.getKey())).append(" | ");
                for (Long statValue : statValues.getValue()) {
                    stats.append(String.format("%" + this.valueColumnWidth + "s ", statValue == null ? NULL_VALUE_SYMBOL : KeyedProfilePage.truncate(statValue.toString(), this.valueColumnWidth)));
                }
                stats.append("\n");
            }
            stats.append("\n");
            for (String statLabel : this.statLabels) {
                stats.append(String.format("%" + this.valueColumnWidth + "s = %s%n", KeyedProfilePage.truncate(statLabel, this.valueColumnWidth), statLabel));
            }
            return stats.toString();
        }

        protected static String truncate(String original, int length) {
            return original.length() <= length ? original : original.substring(0, length);
        }
    }
}

