/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.profiling;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.utils.profiling.ProfileCollator;
import org.multiverse.utils.profiling.ProfileRepository;
import org.multiverse.utils.profiling.SimpleProfileRepositoryCollator;

public final class SimpleProfileRepository
implements ProfileRepository {
    private final ConcurrentMap<ComposedKey, AtomicLong> map = new ConcurrentHashMap<ComposedKey, AtomicLong>();
    private final ConcurrentMap<String, AtomicLong> singleKeyMap = new ConcurrentHashMap<String, AtomicLong>();
    private final ProfileCollator collator = new SimpleProfileRepositoryCollator(this.map);

    @Override
    public void incCounter(String key) {
        this.incCounter(key, 1);
    }

    @Override
    public void incCounter(String key, int amount) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.getOrCreateCounter(key).addAndGet(amount);
    }

    private AtomicLong getOrCreateCounter(String key) {
        AtomicLong found;
        AtomicLong counter = (AtomicLong)this.singleKeyMap.get(key);
        if (counter == null && (found = this.singleKeyMap.putIfAbsent(key, counter = new AtomicLong())) != null) {
            counter = found;
        }
        return counter;
    }

    @Override
    public long getCount(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        AtomicLong counter = (AtomicLong)this.singleKeyMap.get(key);
        return counter == null ? -1L : counter.get();
    }

    @Override
    public void reset() {
        this.map.clear();
        this.singleKeyMap.clear();
    }

    @Override
    public void incCounter(String key1, String key2) {
        this.incCounter(key1, key2, 1L);
    }

    @Override
    public void incCounter(String key1, String key2, long count) {
        AtomicLong counter = this.getOrCreateCounter(key1, key2);
        counter.addAndGet(count);
    }

    @Override
    public Iterator<String> getKey1Iterator() {
        throw new RuntimeException();
    }

    @Override
    public long getCount(String key1, String key2) {
        if (key1 == null || key2 == null) {
            throw new NullPointerException();
        }
        AtomicLong counter = this.getOrCreateCounter(key1, key2);
        return counter == null ? -1L : counter.get();
    }

    @Override
    public void decCounter(String familyName, String key2) {
        this.incCounter(familyName, key2, -1L);
    }

    @Override
    public long sumKey2(String key2) {
        long result = 0L;
        for (Map.Entry entry : this.map.entrySet()) {
            if (!((ComposedKey)entry.getKey()).key2.equals(key2)) continue;
            result += ((AtomicLong)entry.getValue()).get();
        }
        return result;
    }

    @Override
    public long sumKey1(String key1) {
        long result = 0L;
        for (Map.Entry entry : this.map.entrySet()) {
            if (!((ComposedKey)entry.getKey()).key1.equals(key1)) continue;
            result += ((AtomicLong)entry.getValue()).get();
        }
        return result;
    }

    @Override
    public ProfileCollator getCollator() {
        return this.collator;
    }

    public String toString() {
        return this.map.toString() + ", " + this.singleKeyMap.toString();
    }

    private AtomicLong getOrCreateCounter(String key1, String key2) {
        AtomicLong found;
        ComposedKey key = new ComposedKey(key1, key2);
        AtomicLong counter = (AtomicLong)this.map.get(key);
        if (counter == null && (found = this.map.putIfAbsent(key, counter = new AtomicLong())) != null) {
            counter = found;
        }
        return counter;
    }

    static class ComposedKey {
        final String key1;
        final String key2;

        ComposedKey(String key1, String key2) {
            this.key1 = key1;
            this.key2 = key2;
        }

        public String toString() {
            return this.key1 + "#" + this.key2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComposedKey that = (ComposedKey)o;
            if (this.key1 != null ? !this.key1.equals(that.key1) : that.key1 != null) {
                return false;
            }
            return !(this.key2 != null ? !this.key2.equals(that.key2) : that.key2 != null);
        }

        public int hashCode() {
            int result = this.key1 != null ? this.key1.hashCode() : 0;
            result = 31 * result + (this.key2 != null ? this.key2.hashCode() : 0);
            return result;
        }
    }
}

