/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.profiling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.utils.monitoring.ProfilePublisher;
import org.multiverse.utils.profiling.ProfileCollator;
import org.multiverse.utils.profiling.SimpleProfileRepository;

class SimpleProfileRepositoryCollator
implements ProfileCollator {
    private final ConcurrentMap<SimpleProfileRepository.ComposedKey, AtomicLong> repositoryStats;

    public SimpleProfileRepositoryCollator(ConcurrentMap<SimpleProfileRepository.ComposedKey, AtomicLong> repositoryStats) {
        this.repositoryStats = repositoryStats;
    }

    @Override
    public Set<String> getProfileNames() {
        HashSet<String> profileNames = new HashSet<String>();
        for (SimpleProfileRepository.ComposedKey key : this.repositoryStats.keySet()) {
            String candidateKey = key.key2;
            if (SimpleProfileRepositoryCollator.isAtomicObjectKey(candidateKey)) {
                profileNames.add("atomicObject=" + candidateKey);
                continue;
            }
            if (!SimpleProfileRepositoryCollator.isAOTransactionKey(candidateKey)) continue;
            profileNames.add("aoTransactions=" + SimpleProfileRepositoryCollator.getAOTransactionKey(candidateKey));
        }
        return profileNames;
    }

    private static String getAOTransactionKey(String key) {
        return key.substring(0, key.lastIndexOf(46));
    }

    private static boolean isAtomicObjectKey(String candidateKey) {
        return candidateKey != null && candidateKey.contains(".") && !candidateKey.contains("/");
    }

    private static boolean isAOTransactionKey(String candidateKey) {
        return candidateKey != null && candidateKey.contains("/");
    }

    @Override
    public ProfileCollator.ProfilePage getProfilePage(String profileName) {
        if (SimpleProfileRepositoryCollator.isAtomicObjectKey(profileName)) {
            return this.getAtomicObjectPage(profileName);
        }
        if (SimpleProfileRepositoryCollator.isAOTransactionKey(profileName)) {
            return this.getAOTransactionPage(profileName);
        }
        return null;
    }

    private ProfileCollator.ProfilePage getAtomicObjectPage(String profileName) {
        String atomicObjectKey = profileName.replace("atomicObject=", "");
        TreeMap<String, Long> atomicObjectStats = new TreeMap<String, Long>();
        for (Map.Entry entry : this.repositoryStats.entrySet()) {
            SimpleProfileRepository.ComposedKey key = (SimpleProfileRepository.ComposedKey)entry.getKey();
            if (!key.key2.equals(atomicObjectKey)) continue;
            atomicObjectStats.put(key.key1, ((AtomicLong)entry.getValue()).longValue());
        }
        return !atomicObjectStats.isEmpty() ? new AtomicObjectProfilePage(profileName, new ArrayList(atomicObjectStats.keySet()), new ArrayList(atomicObjectStats.values())) : null;
    }

    private ProfileCollator.ProfilePage getAOTransactionPage(String profileName) {
        String aoTransactionsKey = profileName.replace("aoTransactions=", "");
        TreeSet<String> statLabels = new TreeSet<String>();
        HashMap<String, Map<String, Long>> aoTransactionsStats = new HashMap<String, Map<String, Long>>();
        for (Map.Entry entry : this.repositoryStats.entrySet()) {
            SimpleProfileRepository.ComposedKey key = (SimpleProfileRepository.ComposedKey)entry.getKey();
            String candidateKey = key.key2;
            if (!candidateKey.startsWith(aoTransactionsKey)) continue;
            String label = key.key1;
            statLabels.add(label);
            SimpleProfileRepositoryCollator.addStatistic(aoTransactionsStats, SimpleProfileRepositoryCollator.getMethodKey(candidateKey), label, ((AtomicLong)entry.getValue()).longValue());
        }
        return !aoTransactionsStats.isEmpty() ? new AOTransactionProfilePage(profileName, (List<String>)new ArrayList<String>(statLabels), SimpleProfileRepositoryCollator.toStatValues(statLabels, aoTransactionsStats)) : null;
    }

    private static String getMethodKey(String key) {
        return key.substring(key.lastIndexOf(46) + 1);
    }

    private static void addStatistic(Map<String, Map<String, Long>> statistics, String key, String label, long value) {
        if (!statistics.containsKey(key)) {
            statistics.put(key, new HashMap());
        }
        statistics.get(key).put(label, value);
    }

    private static Map<String, List<Long>> toStatValues(SortedSet<String> statLabels, Map<String, Map<String, Long>> aoTransactionsStats) {
        HashMap<String, List<Long>> statValues = new HashMap<String, List<Long>>();
        for (Map.Entry<String, Map<String, Long>> statMap : aoTransactionsStats.entrySet()) {
            statValues.put(statMap.getKey(), SimpleProfileRepositoryCollator.toStatList(statLabels, statMap.getValue()));
        }
        return statValues;
    }

    private static List<Long> toStatList(SortedSet<String> statLabels, Map<String, Long> statValueMap) {
        ArrayList<Long> statValues = new ArrayList<Long>(statLabels.size());
        for (String statLabel : statLabels) {
            statValues.add(statValueMap.get(statLabel));
        }
        return statValues;
    }

    @Override
    public Set<ProfileCollator.ProfilePage> getProfilePages() {
        HashSet<ProfileCollator.ProfilePage> pages = new HashSet<ProfileCollator.ProfilePage>();
        for (String profileName : this.getProfileNames()) {
            pages.add(this.getProfilePage(profileName));
        }
        return pages;
    }

    private static class AOTransactionProfilePage
    extends ProfilePublisher.KeyedProfilePage<String> {
        private static final String PROFILE_PREFIX = "aoTransactions=";
        private static final String METHOD_LABEL = "Method";

        public AOTransactionProfilePage(String name, List<String> statLabels, Map<String, List<Long>> statistics) {
            super(name, statLabels, statistics);
        }

        @Override
        protected String getFormattedKeyLabels() {
            return METHOD_LABEL;
        }

        @Override
        protected String toFormattedString(String key) {
            int typeMethodSeparatorIndex = key.lastIndexOf(46);
            return AOTransactionProfilePage.truncate(key.substring(typeMethodSeparatorIndex + 1), METHOD_LABEL.length());
        }
    }

    private static class AtomicObjectProfilePage
    extends ProfilePublisher.KeyedProfilePage<String> {
        private static final String PROFILE_PREFIX = "atomicObject=";
        private static final String ATOMIC_OBJECT_LABEL = "AtomicObject";

        private AtomicObjectProfilePage(String name, List<String> statLabels, List<Long> statValues) {
            super(name, statLabels, AtomicObjectProfilePage.singleKeyStats(name.replace(PROFILE_PREFIX, ""), statValues));
        }

        private static Map<String, List<Long>> singleKeyStats(String key, List<Long> statValues) {
            HashMap<String, List<Long>> stats = new HashMap<String, List<Long>>();
            stats.put(key, statValues);
            return stats;
        }

        @Override
        protected String getFormattedKeyLabels() {
            return ATOMIC_OBJECT_LABEL;
        }

        @Override
        protected String toFormattedString(String key) {
            return AtomicObjectProfilePage.truncate(key, ATOMIC_OBJECT_LABEL.length());
        }
    }
}

