/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.restartbackoff;

import java.util.concurrent.TimeUnit;
import org.multiverse.api.Transaction;
import org.multiverse.utils.restartbackoff.RestartBackoffPolicy;

public class ExponentialRestartBackoffPolicy
implements RestartBackoffPolicy {
    public static final ExponentialRestartBackoffPolicy INSTANCE_10_MS_MAX = new ExponentialRestartBackoffPolicy();
    private final long maxDelayNs;
    private final long minDelayNs;

    public ExponentialRestartBackoffPolicy() {
        this(1000L, TimeUnit.MILLISECONDS.toNanos(10L), TimeUnit.NANOSECONDS);
    }

    public ExponentialRestartBackoffPolicy(long minDelayNs, long maxDelay, TimeUnit unit) {
        this.maxDelayNs = unit.toNanos(maxDelay);
        this.minDelayNs = minDelayNs;
        if (minDelayNs > this.maxDelayNs) {
            throw new IllegalArgumentException("minimum delay can't be larger than maximum delay");
        }
    }

    public long getMaxDelayNs() {
        return this.maxDelayNs;
    }

    public long getMinDelayNs() {
        return this.minDelayNs;
    }

    @Override
    public void delay(Transaction t, int attempt) throws InterruptedException {
        long delayNs = this.calcDelayNs(attempt);
        ExponentialRestartBackoffPolicy.sleep(delayNs);
    }

    @Override
    public void delayUninterruptible(Transaction t, int attempt) {
        long delayNs = this.calcDelayNs(attempt);
        try {
            ExponentialRestartBackoffPolicy.sleep(delayNs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected static void sleep(long delayNs) throws InterruptedException {
        long millis = TimeUnit.NANOSECONDS.toMillis(delayNs);
        int nanos = (int)(delayNs % 1000000L);
        Thread.sleep(millis, nanos);
    }

    protected long calcDelayNs(int attempt) {
        long delayNs = attempt <= 0 ? 0L : (attempt >= 63 ? Long.MAX_VALUE : 1L << attempt);
        if (this.minDelayNs > 0L && delayNs < this.minDelayNs) {
            delayNs = this.minDelayNs;
        }
        if (this.maxDelayNs > 0L && delayNs > this.maxDelayNs) {
            delayNs = this.maxDelayNs;
        }
        return delayNs;
    }
}

