/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoTransactionFoundException;
import org.multiverse.api.exceptions.RetryError;
import org.multiverse.stms.AbstractTransactionImpl;

public class StmUtilsTest {
    @Before
    public void setup() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void teardown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test(expected=RetryError.class)
    public void retryWithTransactionThrowsRetryError() {
        Transaction t = (Transaction)Mockito.mock(Transaction.class);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        StmUtils.retry();
    }

    @Test(expected=NoTransactionFoundException.class)
    public void retryWithoutTransactionFails() {
        StmUtils.retry();
    }

    @Test(expected=NoTransactionFoundException.class)
    public void abort_whenNoTransactionActive_thenNoTransactionFoundException() {
        StmUtils.abort();
        Assert.fail();
    }

    @Test
    public void abort_whenTransactionActive_thenTransactionAborted() {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        StmUtils.abort();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)1))).abort();
    }

    @Test(expected=NoTransactionFoundException.class)
    public void prepare_whenNoTransactionActive_thenNoTransactionFoundException() {
        StmUtils.prepare();
        Assert.fail();
    }

    @Test
    public void prepare_whenTransactionActive_thenTransactionPrepared() {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        StmUtils.prepare();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)1))).prepare();
    }

    @Test(expected=NoTransactionFoundException.class)
    public void commit_whenNoTransactionActive_thenNoTransactionFoundException() {
        StmUtils.commit();
        Assert.fail();
    }

    @Test
    public void commit_whenTransactionActive_thenTransactionCommitted() {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        StmUtils.commit();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)1))).commit();
    }

    @Test(expected=NoTransactionFoundException.class)
    public void scheduleDeferredTask_whenNoTransactionAvailable_thenNoTransactionFoundException() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        StmUtils.scheduleDeferredTask((Runnable)task);
        Assert.fail();
    }

    @Test(expected=NullPointerException.class)
    public void scheduleDeferredTask_whenTaskNull_thenNullPointerException() {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        StmUtils.scheduleDeferredTask(null);
    }

    @Test
    public void scheduleDeferredTask_whenTransactionAvailable() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        StmUtils.scheduleDeferredTask((Runnable)task);
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)0))).run();
        tx.commit();
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test(expected=NoTransactionFoundException.class)
    public void scheduleCompensatingTask_whenNoTransactionAvailable_thenNoTransactionFoundException() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        StmUtils.scheduleCompensatingTask((Runnable)task);
    }

    @Test(expected=NullPointerException.class)
    public void scheduleCompensatingTask_whenTaskNull_thenNullPointerException() {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        StmUtils.scheduleCompensatingTask(null);
    }

    @Test
    public void scheduleCompensatingTask_whenTransactionAvailable() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        StmUtils.scheduleCompensatingTask((Runnable)task);
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)0))).run();
        tx.abort();
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)1))).run();
    }
}

