/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoTransactionFoundException;

public class ThreadLocalTransaction_getRequiredThreadLocalTransactionTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @Test(expected=NoTransactionFoundException.class)
    public void whenNoTransactionAvailable_thenNoTransactionFoundException() {
        ThreadLocalTransaction.getRequiredThreadLocalTransaction();
    }

    @Test
    public void whenTransactionAvailable_thenItIsReturned() {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        Transaction found = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        Assert.assertSame((Object)tx, (Object)found);
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).getStatus();
    }
}

