/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionLifecycleEvent;
import org.multiverse.api.TransactionLifecycleListener;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.stms.AbstractTransaction;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.utils.clock.StrictPrimitiveClock;

public class AbstractTransaction_abortTest {
    private StrictPrimitiveClock clock;

    @Before
    public void setUp() {
        this.clock = new StrictPrimitiveClock(1L);
    }

    @Test
    public void whenActive_thenAbort() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        long startVersion = this.clock.getVersion();
        tx.abort();
        Assert.assertEquals((long)startVersion, (long)this.clock.getVersion());
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    @Ignore
    public void whenDoAbortThrowsError() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        RuntimeException expected = new RuntimeException();
        ((AbstractTransaction)Mockito.doThrow((Throwable)expected).when((Object)tx)).doAbortActive();
        try {
            tx.abort();
            Assert.fail();
        }
        catch (RuntimeException found) {
            Assert.assertSame((Object)expected, (Object)found);
            TestUtils.assertIsAborted(new Transaction[]{tx});
        }
    }

    @Test
    public void whenPrepared_thenAbort() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        tx.prepare();
        tx.abort();
        ((AbstractTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)1))).doAbortPrepared();
    }

    @Test
    public void whenPreparedAndPreAbortTaskFails_thenDoAbortPreparedNotSkipped() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        tx.prepare();
        RuntimeException expected = new RuntimeException();
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)expected).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
        try {
            tx.abort();
            Assert.fail();
        }
        catch (RuntimeException found) {
            Assert.assertSame((Object)expected, (Object)found);
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
        ((AbstractTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)1))).doAbortPrepared();
    }

    @Test
    public void whenAlreadyCommitted_thenDeadTransactionException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.commit();
        long startVersion = this.clock.getVersion();
        try {
            tx.abort();
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)startVersion, (long)this.clock.getVersion());
        TestUtils.assertIsCommitted(new Transaction[]{tx});
    }

    @Test
    public void whenAborted_thenIgnored() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.abort();
        long startVersion = this.clock.getVersion();
        tx.abort();
        Assert.assertEquals((long)startVersion, (long)this.clock.getVersion());
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenAbort_thenPreAndPostCommitTasksAreCalled() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        tx.abort();
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.preCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.postCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.postAbort);
    }

    @Test
    public void whenPreAbortTaskFails_thenStillAborted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        RuntimeException exception = new RuntimeException();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)exception).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
        tx.registerLifecycleListener(listener);
        try {
            tx.abort();
            Assert.fail();
        }
        catch (RuntimeException found) {
            Assert.assertSame((Object)exception, (Object)found);
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.preCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.postCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.postAbort);
    }

    @Test
    public void whenPostAbortTaskFails_exceptionThrown() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        RuntimeException exception = new RuntimeException();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)exception).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.postAbort);
        tx.registerLifecycleListener(listener);
        try {
            tx.abort();
            Assert.fail();
        }
        catch (RuntimeException found) {
            Assert.assertSame((Object)exception, (Object)found);
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.preCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.postCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.postAbort);
    }
}

