/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Latch;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.stms.AbstractTransaction;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.utils.latches.CheapLatch;

public class AbstractTransaction_registerRetryLatchTest {
    @Test
    public void whenActiveAndNullLatch_thenNullPointerException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            tx.registerRetryLatch(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive(new Transaction[]{tx});
    }

    @Test
    public void whenActiveAndDoRegisterRetryLatchReturnsTrue_thenSuccess() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        CheapLatch latch = new CheapLatch();
        Mockito.when((Object)tx.doRegisterRetryLatch((Latch)latch, tx.getReadVersion() + 1L)).thenReturn((Object)true);
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive(new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenActiveAndDoRegisterRetryLatchReturnsFalse_thenNoRetryPossibleException() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        CheapLatch latch = new CheapLatch();
        Mockito.when((Object)tx.doRegisterRetryLatch((Latch)latch, tx.getReadVersion() + 1L)).thenReturn((Object)false);
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException noRetryPossibleException) {
            // empty catch block
        }
        TestUtils.assertIsActive(new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenPreparedAndDoRegisterRetryLatchReturnsTrue_thenSuccess() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        tx.prepare();
        CheapLatch latch = new CheapLatch();
        Mockito.when((Object)tx.doRegisterRetryLatch((Latch)latch, tx.getReadVersion() + 1L)).thenReturn((Object)true);
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsPrepared(new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenPreparedAndDoRegisterRetryLatchReturnsFalse_thenNoRetryPossibleException() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        tx.prepare();
        CheapLatch latch = new CheapLatch();
        Mockito.when((Object)tx.doRegisterRetryLatch((Latch)latch, tx.getReadVersion() + 1L)).thenReturn((Object)false);
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException noRetryPossibleException) {
            // empty catch block
        }
        TestUtils.assertIsPrepared(new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.commit();
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted(new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.abort();
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }
}

