/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionLifecycleEvent;
import org.multiverse.api.TransactionLifecycleListener;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.utils.clock.PrimitiveClock;
import org.multiverse.utils.clock.StrictPrimitiveClock;

public class AbstractTransaction_restartTest {
    private StrictPrimitiveClock clock;

    @Before
    public void setUp() {
        this.clock = new StrictPrimitiveClock(1L);
    }

    @Test
    public void whenActive_thenTransactionRestarted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        long version = this.clock.getVersion();
        tx.restart();
        TestUtils.assertIsActive(new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.clock.getVersion());
    }

    @Test
    public void whenActive_thenListenersAreNotified() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        Mockito.reset((Object[])new TransactionLifecycleListener[]{listener});
        tx.restart();
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.postAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.preCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.postCommit);
    }

    @Test
    public void whenActiveAndPreAbortListenerFails_thenTransactionAborted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
        try {
            tx.restart();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenActiveAndPostAbortListenerFails_thenTransactionAborted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.postAbort);
        try {
            tx.restart();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenPreparedAndPreAbortListenerFails_thenTransactionAborted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
        tx.prepare();
        try {
            tx.restart();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenPreparedAndPostAbortListenerFails_thenTransactionAborted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.postAbort);
        tx.prepare();
        try {
            tx.restart();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenPrepared_thenTransactionIsRestarted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        tx.prepare();
        long version = this.clock.getVersion();
        tx.restart();
        TestUtils.assertIsActive(new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.clock.getVersion());
    }

    @Test
    public void whenCommitted_thenTransactionIsRestarted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        tx.commit();
        long version = this.clock.getVersion();
        tx.restart();
        TestUtils.assertIsActive(new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.clock.getVersion());
    }

    @Test
    public void whenCommitted_thenNoScheduledTasksAreExecuted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        tx.commit();
        Mockito.reset((Object[])new TransactionLifecycleListener[]{listener});
        tx.restart();
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)Mockito.any(), (TransactionLifecycleEvent)Mockito.any());
    }

    @Test
    public void whenAbortedTransactionIsRestarted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        tx.abort();
        long version = this.clock.getVersion();
        tx.restart();
        TestUtils.assertIsActive(new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.clock.getVersion());
    }

    @Test
    public void whenAborted_thenNoListenersExecuted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        tx.abort();
        Mockito.reset((Object[])new TransactionLifecycleListener[]{listener});
        tx.restart();
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)Mockito.any(), (TransactionLifecycleEvent)Mockito.any());
    }
}

