/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.api.Latch;
import org.multiverse.utils.Listeners;
import org.multiverse.utils.latches.CheapLatch;

public class ListenersTest {
    @Test
    public void getNext() {
        CheapLatch latch1 = new CheapLatch();
        CheapLatch latch2 = new CheapLatch();
        Listeners tail = new Listeners((Latch)latch2, null);
        Listeners head = new Listeners((Latch)latch1, tail);
        Assert.assertSame((Object)tail, (Object)head.getNext());
        Assert.assertNull((Object)tail.getNext());
    }

    @Test
    public void testOpenAllOnClosedListeners() {
        CheapLatch latch1 = new CheapLatch();
        CheapLatch latch2 = new CheapLatch();
        Listeners listeners = new Listeners((Latch)latch1, new Listeners((Latch)latch2, null));
        listeners.openAll();
        Assert.assertTrue((boolean)latch1.isOpen());
        Assert.assertTrue((boolean)latch2.isOpen());
    }

    @Test
    public void testOpenAllOnOpenListeners() {
        CheapLatch latch1 = new CheapLatch(true);
        CheapLatch latch2 = new CheapLatch(true);
        Listeners listeners = new Listeners((Latch)latch1, new Listeners((Latch)latch2, null));
        listeners.openAll();
        Assert.assertTrue((boolean)latch1.isOpen());
        Assert.assertTrue((boolean)latch2.isOpen());
    }
}

