/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.backoff;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.Test;
import org.multiverse.utils.backoff.ExponentialBackoffPolicy;

public class ExponentialBackoffPolicyTest {
    @Test
    public void construction_INSTANCE() {
        ExponentialBackoffPolicy policy = ExponentialBackoffPolicy.INSTANCE_10_MS_MAX;
        Assert.assertEquals((long)1000L, (long)policy.getMinDelayNs());
        Assert.assertEquals((long)TimeUnit.MILLISECONDS.toNanos(10L), (long)policy.getMaxDelayNs());
    }

    @Test(expected=IllegalArgumentException.class)
    public void minimumDelayCantBeLargerThanMaximumDelay() {
        new ExponentialBackoffPolicy(10L, 9L, TimeUnit.NANOSECONDS);
    }

    @Test
    public void noDelayForZeroIteration() {
        ExponentialBackoffPolicy policy = new ExponentialBackoffPolicy();
        long delayNs = policy.calcDelayNs(0);
        Assert.assertEquals((long)policy.getMinDelayNs(), (long)delayNs);
    }

    @Test
    public void minimumDelay() {
        long minDelay = 10000L;
        ExponentialBackoffPolicy policy = new ExponentialBackoffPolicy(minDelay, 1L, TimeUnit.SECONDS);
        long delayNs = policy.calcDelayNs(1);
        Assert.assertEquals((long)minDelay, (long)delayNs);
    }

    @Test
    public void tooLargeValueTruncated() {
        long maxDelayNs = 10000L;
        ExponentialBackoffPolicy policy = new ExponentialBackoffPolicy(100L, maxDelayNs, TimeUnit.NANOSECONDS);
        long delayNs = policy.calcDelayNs(100);
        Assert.assertEquals((long)maxDelayNs, (long)delayNs);
    }

    @Test
    public void happyFlow() {
        long maxDelayNs = 1000000L;
        ExponentialBackoffPolicy policy = new ExponentialBackoffPolicy(100L, maxDelayNs, TimeUnit.NANOSECONDS);
        Assert.assertEquals((long)1024L, (long)policy.calcDelayNs(10));
        Assert.assertEquals((long)4096L, (long)policy.calcDelayNs(12));
    }

    @Test
    public void sleep() throws InterruptedException {
        long sleepNs = TimeUnit.MILLISECONDS.toNanos(100L);
        long startNs = System.nanoTime();
        LockSupport.parkNanos(sleepNs);
        long elapsedNs = System.nanoTime() - startNs;
        Assert.assertTrue(((double)elapsedNs > 0.95 * (double)sleepNs ? 1 : 0) != 0);
    }
}

