/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.clock;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.utils.clock.PrimitiveClock;
import org.multiverse.utils.clock.StrictPrimitiveClock;

public class StrictPrimitiveClockStressTest {
    private final long tickCount = 10000000L;
    private final PrimitiveClock clock = new StrictPrimitiveClock();
    private final int threadCount = Math.max(Runtime.getRuntime().availableProcessors(), 2);

    @Test
    public void test() {
        System.out.printf("StrictPrimitiveClockStressTest threadCount=%s  tickCount/thread=%s\n", this.threadCount, 10000000L);
        TestThread[] threads = this.createThreads();
        TestUtils.startAll(threads);
        TestUtils.joinAll(threads);
        long expectedTime = 10000000L * (long)this.threadCount;
        Assert.assertEquals((long)expectedTime, (long)this.clock.getVersion());
    }

    public TickThread[] createThreads() {
        TickThread[] threads = new TickThread[this.threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new TickThread(k);
        }
        return threads;
    }

    class TickThread
    extends TestThread {
        public TickThread(int id) {
            super("TickThread-" + id);
        }

        @Override
        public void doRun() {
            long previousTime = StrictPrimitiveClockStressTest.this.clock.getVersion();
            for (long k = 0L; k < 10000000L; ++k) {
                long nextTime = StrictPrimitiveClockStressTest.this.clock.tick();
                if (nextTime <= previousTime) {
                    Assert.fail();
                }
                previousTime = nextTime;
            }
        }
    }
}

