/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.commitlock;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.api.Transaction;
import org.multiverse.utils.commitlock.CommitLock;
import org.multiverse.utils.commitlock.CommitLockFilter;
import org.multiverse.utils.commitlock.GenericCommitLockPolicy;
import org.multiverse.utils.commitlock.PassAllCommitLockFilter;

public class GenericCommitLockPolicyTest {
    private GenericCommitLockPolicy policy;

    @Before
    public void setUp() {
        this.policy = new GenericCommitLockPolicy(10, 10);
    }

    @Test
    public void construction() {
        GenericCommitLockPolicy policy = new GenericCommitLockPolicy(10, 20);
        Assert.assertEquals((long)10L, (long)policy.getSpinAttemptsPerLockCount());
        Assert.assertEquals((long)20L, (long)policy.getRetryCount());
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructWithTooSmallSpinAttemptsPerLock() {
        new GenericCommitLockPolicy(-1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructWithTooSmallRetryCount() {
        new GenericCommitLockPolicy(0, -1);
    }

    @Test(expected=NullPointerException.class)
    @Ignore
    public void tryLock_failsIfLockOwnerIsNull() {
        CommitLock commitLock = (CommitLock)Mockito.mock(CommitLock.class);
        this.policy.tryAcquire(commitLock, (CommitLockFilter)PassAllCommitLockFilter.INSTANCE, null);
    }

    @Test
    @Ignore
    public void tryLock_succeedsWithNullLock() {
    }

    @Test
    public void tryLock() {
        this.tryLock(true);
        this.tryLock(false);
    }

    public void tryLock(boolean expectedResult) {
        CommitLock commitLock = (CommitLock)Mockito.mock(CommitLock.class);
        Transaction t = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)commitLock.___tryLock(t)).thenReturn((Object)expectedResult);
        boolean result = this.policy.tryAcquire(commitLock, (CommitLockFilter)PassAllCommitLockFilter.INSTANCE, t);
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void tryLockAll_nullTransactionFails() {
        this.policy.tryAcquireAll(new CommitLock[0], (CommitLockFilter)PassAllCommitLockFilter.INSTANCE, null);
    }

    @Test
    @Ignore
    public void tryLockAll_nullLocksSucceeds() {
    }

    @Test
    @Ignore
    public void tryLockAll_emptyLocksSucceeds() {
    }

    @Test
    public void testToString() {
        GenericCommitLockPolicy policy = new GenericCommitLockPolicy(10, 20);
        Assert.assertEquals((Object)"GenericCommitLockPolicy(retryCount=20, spinAttemptsPerLockCount=10)", (Object)policy.toString());
    }
}

