/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.latches;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Latch;
import org.multiverse.utils.latches.AwaitThread;
import org.multiverse.utils.latches.AwaitUninterruptibleThread;
import org.multiverse.utils.latches.CheapLatch;

public class CheapLatchTest {
    @After
    public void tearDown() {
        Thread.interrupted();
    }

    @Test
    public void test_OPEN_LATCH() {
        Assert.assertTrue((boolean)CheapLatch.OPEN_LATCH.isOpen());
    }

    @Test
    public void constructorWithOpenLatch() {
        CheapLatch latch = new CheapLatch(true);
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void constructorWithClosedLatch() {
        CheapLatch latch = new CheapLatch(false);
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void constructorWithNoArgs() {
        CheapLatch latch = new CheapLatch();
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void openAlreadyOpenLatch() {
        CheapLatch latch = new CheapLatch(true);
        latch.open();
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void awaitOpenLatchCompletes() throws InterruptedException {
        CheapLatch latch = new CheapLatch(true);
        latch.await();
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void awaitClosedLatchIsInterruptedIfStartingWithInterruptedFlag() throws InterruptedException {
        CheapLatch latch = new CheapLatch();
        AwaitThread awaitThread = new AwaitThread((Latch)latch, true);
        awaitThread.start();
        awaitThread.join();
        Assert.assertTrue((boolean)(awaitThread.getThrowable() instanceof InterruptedException));
    }

    @Test
    public void awaitClosedLatchCompletesWhenLatchIsOpened() throws InterruptedException {
        CheapLatch latch = new CheapLatch();
        AwaitThread awaitThread1 = new AwaitThread((Latch)latch);
        AwaitThread awaitThread2 = new AwaitThread((Latch)latch);
        TestUtils.startAll(awaitThread1, awaitThread2);
        TestUtils.sleepMs(500L);
        Assert.assertTrue((boolean)awaitThread1.isAlive());
        Assert.assertTrue((boolean)awaitThread2.isAlive());
        latch.open();
        TestUtils.joinAll(awaitThread1, awaitThread2);
    }

    @Test
    public void awaitUninterruptibleCompletesWhenLatchIsOpen() {
        CheapLatch latch = new CheapLatch(true);
        AwaitUninterruptibleThread awaitThread = new AwaitUninterruptibleThread((Latch)latch, false);
        TestUtils.startAll(awaitThread);
        TestUtils.joinAll(awaitThread);
    }

    @Test
    public void awaitUninterruptibleCompletesIsOpened() {
        CheapLatch latch = new CheapLatch();
        AwaitUninterruptibleThread awaitThread1 = new AwaitUninterruptibleThread((Latch)latch, false);
        AwaitUninterruptibleThread awaitThread2 = new AwaitUninterruptibleThread((Latch)latch, true);
        TestUtils.startAll(awaitThread1, awaitThread2);
        TestUtils.sleepMs(500L);
        Assert.assertTrue((boolean)awaitThread1.isAlive());
        Assert.assertTrue((boolean)awaitThread2.isAlive());
        latch.open();
        TestUtils.joinAll(awaitThread1, awaitThread2);
        Assert.assertFalse((boolean)awaitThread1.hasEndedWithInterruptStatus());
        Assert.assertTrue((boolean)awaitThread2.hasEndedWithInterruptStatus());
    }

    @Test
    public void tryAwaitWithTimeoutFails() throws InterruptedException {
        CheapLatch latch = new CheapLatch(false);
        try {
            latch.tryAwait(10L, TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void tryAwaitUninterruptibleFails() {
        CheapLatch latch = new CheapLatch(false);
        try {
            latch.tryAwaitUninterruptible(10L, TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void testToString() {
        CheapLatch latch = new CheapLatch();
        Assert.assertEquals((Object)"CheapLatch(open=false)", (Object)latch.toString());
        latch.open();
        Assert.assertEquals((Object)"CheapLatch(open=true)", (Object)latch.toString());
    }
}

