/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.latches;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.Latch;
import org.multiverse.utils.latches.AwaitThread;
import org.multiverse.utils.latches.AwaitUninterruptibleThread;
import org.multiverse.utils.latches.StandardLatch;

public class StandardLatchTest {
    @After
    public void tearDown() {
        Thread.interrupted();
    }

    @Test
    public void noArgConstructor() {
        StandardLatch latch = new StandardLatch();
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void singleArgConstructor() {
        Assert.assertTrue((boolean)new StandardLatch(true).isOpen());
        Assert.assertFalse((boolean)new StandardLatch(false).isOpen());
    }

    @Test
    public void openLatchThatAlreadyIsOpen() {
        StandardLatch latch = new StandardLatch(true);
        latch.open();
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void awaitOnOpenLatch() throws InterruptedException {
        StandardLatch latch = new StandardLatch(true);
        latch.await();
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void awaitOnOpenLatchWithInterruptedStatus() throws InterruptedException {
        Thread.currentThread().interrupt();
        StandardLatch latch = new StandardLatch(true);
        latch.await();
        Assert.assertTrue((boolean)latch.isOpen());
        TestUtils.assertIsInterrupted(Thread.currentThread());
    }

    @Test
    public void await() {
        StandardLatch latch = new StandardLatch();
        AwaitThread awaitThread1 = new AwaitThread((Latch)latch);
        AwaitThread awaitThread2 = new AwaitThread((Latch)latch);
        TestUtils.startAll(awaitThread1, awaitThread2);
        TestUtils.sleepMs(100L);
        TestUtils.assertAlive(awaitThread1, awaitThread2);
        latch.open();
        TestUtils.joinAll(awaitThread1, awaitThread2);
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void awaitOnUninterruptibleOpenLatch() throws InterruptedException {
        StandardLatch latch = new StandardLatch(true);
        latch.awaitUninterruptible();
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void awaitOnUninterruptibleOpenLatchWithInterruptedStatus() throws InterruptedException {
        Thread.currentThread().interrupt();
        StandardLatch latch = new StandardLatch(true);
        latch.awaitUninterruptible();
        Assert.assertTrue((boolean)latch.isOpen());
        TestUtils.assertIsInterrupted(Thread.currentThread());
    }

    @Test
    public void awaitUninterruptible() {
        StandardLatch latch = new StandardLatch();
        AwaitUninterruptibleThread awaitThread1 = new AwaitUninterruptibleThread((Latch)latch);
        AwaitUninterruptibleThread awaitThread2 = new AwaitUninterruptibleThread((Latch)latch);
        TestUtils.startAll(awaitThread1, awaitThread2);
        TestUtils.sleepMs(100L);
        TestUtils.assertAlive(awaitThread1, awaitThread2);
        latch.open();
        TestUtils.joinAll(awaitThread1, awaitThread2);
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test(expected=NullPointerException.class)
    public void tryAwaitFailsWithNullUnit() throws InterruptedException {
        StandardLatch latch = new StandardLatch();
        latch.tryAwait(1L, null);
    }

    @Test
    public void tryAwaitOnOpenLatch() throws InterruptedException {
        StandardLatch latch = new StandardLatch(true);
        boolean result = latch.tryAwait(1L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void tryAwaitOnClosedLatchAndTimeout() throws InterruptedException {
        StandardLatch latch = new StandardLatch(false);
        boolean result = latch.tryAwait(1L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void tryAwaitUninterruptibleOnOpenLatch() {
        StandardLatch latch = new StandardLatch(true);
        boolean result = latch.tryAwaitUninterruptible(1L, TimeUnit.NANOSECONDS);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void tryAwaitUninterruptibleWithNullUnit() {
        StandardLatch latch = new StandardLatch();
        try {
            latch.tryAwaitUninterruptible(1L, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void tryAwaitUninterruptibleWithTimeout() {
        StandardLatch latch = new StandardLatch();
        boolean result = latch.tryAwaitUninterruptible(100L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)result);
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void tryAwaitUninterruptibleWithInterruptStatus() {
        StandardLatch latch = new StandardLatch();
        Thread.currentThread().interrupt();
        boolean result = latch.tryAwaitUninterruptible(100L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)result);
        Assert.assertFalse((boolean)latch.isOpen());
        TestUtils.assertIsInterrupted(Thread.currentThread());
    }

    @Test
    public void tryAwaitUninterruptible() {
        StandardLatch latch = new StandardLatch();
        TryAwaitUninterruptibleThread t = new TryAwaitUninterruptibleThread((Latch)latch, 500L, TimeUnit.MILLISECONDS);
        t.start();
        TestUtils.sleepMs(50L);
        Assert.assertNull((Object)t.result);
        Assert.assertTrue((boolean)t.isAlive());
        latch.open();
        TestUtils.joinAll(t);
        Assert.assertTrue((boolean)t.result);
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void tryAwaitUninterruptibleInterruptedWhileWaiting() {
        StandardLatch latch = new StandardLatch();
        TryAwaitUninterruptibleThread t = new TryAwaitUninterruptibleThread((Latch)latch, 500L, TimeUnit.MILLISECONDS);
        TestUtils.startAll(t);
        TestUtils.sleepMs(50L);
        t.interrupt();
        Assert.assertNull((Object)t.result);
        Assert.assertTrue((boolean)t.isAlive());
        latch.open();
        TestUtils.joinAll(t);
        Assert.assertTrue((boolean)t.hasEndedWithInterruptStatus());
        Assert.assertTrue((boolean)t.result);
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"StandardLatch(open=false)", (Object)new StandardLatch(false).toString());
        Assert.assertEquals((Object)"StandardLatch(open=true)", (Object)new StandardLatch(true).toString());
    }

    class TryAwaitUninterruptibleThread
    extends TestThread {
        private final Latch latch;
        private long timeout;
        private TimeUnit unit;
        private volatile Boolean result;

        TryAwaitUninterruptibleThread(Latch latch, long timeout, TimeUnit unit) {
            super("TryAwaitUninterruptibleThread");
            this.latch = latch;
            this.timeout = timeout;
            this.unit = unit;
        }

        @Override
        public void doRun() throws Exception {
            this.result = this.latch.tryAwaitUninterruptible(this.timeout, this.unit);
        }
    }
}

