/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.profiling;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.utils.profiling.ProfileCollator;
import org.multiverse.utils.profiling.SimpleProfileRepository;

public class SimpleProfileRepositoryCollatorTest {
    private SimpleProfileRepository repository;

    @Before
    public void setUp() {
        this.repository = new SimpleProfileRepository();
    }

    @Test
    public void profileNamesContainAtomicObjectAndAOTransactions() {
        this.repository.incCounter("#kills", "uk/gov/mi6/Agents.meet()");
        this.repository.incCounter("total damage", "uk/gov/mi6/Agents.performMission()");
        this.repository.incCounter("#agents", "uk.gov.mi6.Agents");
        Assert.assertEquals(SimpleProfileRepositoryCollatorTest.asSet("atomicObject=uk.gov.mi6.Agents", "aoTransactions=uk/gov/mi6/Agents"), (Object)this.repository.getCollator().getProfileNames());
    }

    private static <E> Set<E> asSet(E ... elems) {
        return new HashSet<E>(Arrays.asList(elems));
    }

    @Test
    public void profilePageForNonexistentFileIsNull() {
        Assert.assertNull((Object)this.repository.getCollator().getProfilePage("nonexistent"));
    }

    @Test
    public void profilePageForAtomicObjectListsSummary() {
        String atomicObjectKey = "uk.gov.mi6.Agents";
        this.repository.incCounter("#agents", atomicObjectKey, 1L);
        this.repository.incCounter("avg age", atomicObjectKey, 2L);
        this.repository.incCounter("life expectancy", atomicObjectKey, 3L);
        ProfileCollator.ProfilePage page = this.repository.getCollator().getProfilePage("atomicObject=" + atomicObjectKey);
        Assert.assertEquals(Arrays.asList("#agents", "avg age", "life expectancy"), (Object)page.getStatLabels());
        Map statistics = page.getStatistics();
        Assert.assertEquals((long)1L, (long)statistics.size());
        Assert.assertEquals((Object)atomicObjectKey, statistics.keySet().iterator().next());
        Assert.assertEquals(Arrays.asList(1L, 2L, 3L), statistics.get(atomicObjectKey));
    }

    @Test
    public void profilePageForAOTransactionsListsMethods() {
        String methodKey1 = "meet()";
        this.repository.incCounter("#kills", "uk/gov/mi6/Agents." + methodKey1, 1L);
        this.repository.incCounter("expenses", "uk/gov/mi6/Agents." + methodKey1, 2L);
        String methodKey2 = "performMission()";
        this.repository.incCounter("#gadgets", "uk/gov/mi6/Agents." + methodKey2, 3L);
        this.repository.incCounter("total damage", "uk/gov/mi6/Agents." + methodKey2, 4L);
        ProfileCollator.ProfilePage page = this.repository.getCollator().getProfilePage("aoTransactions=uk/gov/mi6/Agents");
        Assert.assertEquals(Arrays.asList("#gadgets", "#kills", "expenses", "total damage"), (Object)page.getStatLabels());
        Map statistics = page.getStatistics();
        Assert.assertEquals((long)2L, (long)statistics.size());
        Assert.assertTrue((String)"Expected key 'meet()'", (boolean)statistics.containsKey(methodKey1));
        Assert.assertEquals(Arrays.asList(null, 1L, 2L, null), statistics.get(methodKey1));
        Assert.assertTrue((String)"Expected key 'performMission()'", (boolean)statistics.containsKey(methodKey2));
        Assert.assertEquals(Arrays.asList(3L, null, null, 4L), statistics.get(methodKey2));
    }

    @Test
    public void profilePagesContainAtomicObjectAndAOTransactions() {
        this.repository.incCounter("#kills", "uk/gov/mi6/Agents.meet()");
        this.repository.incCounter("total damage", "uk/gov/mi6/Agents.performMission()");
        this.repository.incCounter("#agents", "uk.gov.mi6.Agents");
        HashSet<String> pageNames = new HashSet<String>();
        for (ProfileCollator.ProfilePage page : this.repository.getCollator().getProfilePages()) {
            pageNames.add(page.getName());
        }
        Assert.assertEquals(SimpleProfileRepositoryCollatorTest.asSet("atomicObject=uk.gov.mi6.Agents", "aoTransactions=uk/gov/mi6/Agents"), pageNames);
    }
}

