/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.profiling;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.utils.profiling.SimpleProfileRepository;

public class SimpleProfileRepositoryTest {
    private SimpleProfileRepository repository;

    @Before
    public void setUp() {
        this.repository = new SimpleProfileRepository();
    }

    @Test(expected=NullPointerException.class)
    public void getCount_key_nullKeyFails() {
        this.repository.getCount(null);
    }

    @Test
    public void getCount_key_nonExisting() {
        long result = this.repository.getCount("somenonexistingkey");
        Assert.assertEquals((long)-1L, (long)result);
    }

    @Test(expected=NullPointerException.class)
    public void incCounter_key_nullKeyFails() {
        this.repository.incCounter(null);
    }

    @Test
    public void incCounter_key() {
        String key = "somekey";
        this.repository.incCounter(key);
        Assert.assertEquals((long)1L, (long)this.repository.getCount(key));
        this.repository.incCounter(key);
        Assert.assertEquals((long)2L, (long)this.repository.getCount(key));
    }

    @Test(expected=NullPointerException.class)
    public void incCounter_key_value_nullKeyFails() {
        this.repository.incCounter(null, 1);
    }

    @Test
    public void incCounter_key_value() {
        String key = "somekey";
        this.repository.incCounter(key, 10);
        Assert.assertEquals((long)10L, (long)this.repository.getCount(key));
        this.repository.incCounter(key, 20);
        Assert.assertEquals((long)30L, (long)this.repository.getCount(key));
    }

    @Test(expected=NullPointerException.class)
    public void getCounter_key1_key2_nullKey1Fails() {
        this.repository.getCount(null, "foo");
    }

    @Test(expected=NullPointerException.class)
    public void getCounter_key1_key2_nullKey2Fails() {
        this.repository.getCount("foo", null);
    }

    @Test
    public void incCounter_key1_key2() {
        this.repository.incCounter("foo", "bar");
        Assert.assertEquals((long)1L, (long)this.repository.getCount("foo", "bar"));
    }

    @Test
    public void incCounterMultipleKeys_key1_key2() {
        this.repository.incCounter("foo1", "bar1");
        this.repository.incCounter("foo1", "bar2");
        this.repository.incCounter("foo2", "bar1");
        this.repository.incCounter("foo1", "bar1");
        Assert.assertEquals((long)2L, (long)this.repository.getCount("foo1", "bar1"));
        Assert.assertEquals((long)1L, (long)this.repository.getCount("foo1", "bar2"));
        Assert.assertEquals((long)1L, (long)this.repository.getCount("foo2", "bar1"));
    }
}

