/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.multiverse.MultiverseConstants;
import org.multiverse.api.Latch;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionConfig;
import org.multiverse.api.TransactionLifecycleEvent;
import org.multiverse.api.TransactionLifecycleListener;
import org.multiverse.api.TransactionStatus;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.stms.AbstractTransactionConfig;
import org.multiverse.stms.AbstractTransactionSnapshot;

public abstract class AbstractTransaction<C extends AbstractTransactionConfig, S extends AbstractTransactionSnapshot>
implements Transaction,
MultiverseConstants {
    protected final C config;
    private List<TransactionLifecycleListener> listeners;
    private long version;
    private TransactionStatus status;

    public AbstractTransaction(C config) {
        assert (config != null);
        this.config = config;
    }

    @Override
    public long getReadVersion() {
        return this.version;
    }

    @Override
    public final TransactionStatus getStatus() {
        return this.status;
    }

    @Override
    public TransactionConfig getConfig() {
        return this.config;
    }

    protected final void init() {
        this.status = TransactionStatus.active;
        this.version = ((AbstractTransactionConfig)this.config).clock.getVersion();
        this.doInit();
    }

    protected void doInit() {
    }

    protected void doClear() {
    }

    @Override
    public final void registerLifecycleListener(TransactionLifecycleListener listener) {
        switch (this.status) {
            case active: 
            case prepared: {
                if (listener == null) {
                    throw new NullPointerException();
                }
                if (this.listeners == null) {
                    this.listeners = new LinkedList<TransactionLifecycleListener>();
                }
                this.listeners.add(listener);
                break;
            }
            case committed: {
                String committedMsg = MessageFormat.format("Can't register TransactionLifecycleListener on already committed transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case aborted: {
                String abortMsg = MessageFormat.format("Can't register TransactionLifecycleListener on already aborted transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(abortMsg);
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void prepare() {
        switch (this.status) {
            case active: {
                try {
                    this.notifyAll(TransactionLifecycleEvent.preCommit);
                    this.doPrepare();
                    this.status = TransactionStatus.prepared;
                    break;
                }
                finally {
                    if (this.status != TransactionStatus.prepared) {
                        this.abort();
                    }
                }
            }
            case prepared: {
                break;
            }
            case committed: {
                String committedMsg = MessageFormat.format("Can't prepare already committed transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case aborted: {
                String abortedMsg = MessageFormat.format("Can't prepare already aborted transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    protected void doPrepare() {
    }

    @Override
    public final void restart() {
        switch (this.status) {
            case active: 
            case prepared: {
                this.abort();
            }
            case committed: 
            case aborted: {
                this.clearListeners();
                this.doClear();
                this.init();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void clearListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    private void notifyAll(TransactionLifecycleEvent event) {
        if (this.listeners == null) {
            return;
        }
        for (TransactionLifecycleListener listener : this.listeners) {
            listener.notify(this, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void abort() {
        switch (this.status) {
            case active: 
            case prepared: {
                try {
                    try {
                        this.notifyAll(TransactionLifecycleEvent.preAbort);
                    }
                    finally {
                        this.status = TransactionStatus.aborted;
                        if (this.status == TransactionStatus.active) {
                            this.doAbortActive();
                        } else {
                            this.doAbortPrepared();
                        }
                    }
                    this.notifyAll(TransactionLifecycleEvent.postAbort);
                    break;
                }
                finally {
                    this.clearListeners();
                }
            }
            case committed: {
                String committedMsg = MessageFormat.format("Can't abort already committed transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case aborted: {
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    protected void doAbortPrepared() {
    }

    protected void doAbortActive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void commit() {
        switch (this.status) {
            case active: {
                this.prepare();
            }
            case prepared: {
                try {
                    this.doStore();
                    this.status = TransactionStatus.committed;
                    this.notifyAll(TransactionLifecycleEvent.postCommit);
                    break;
                }
                finally {
                    if (this.status != TransactionStatus.committed) {
                        this.abort();
                    }
                }
            }
            case committed: {
                return;
            }
            case aborted: {
                String abortedMsg = MessageFormat.format("Can't commit already aborted transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected void doStore() {
    }

    @Override
    public final void registerRetryLatch(Latch latch) {
        switch (this.status) {
            case active: 
            case prepared: {
                if (latch == null) {
                    throw new NullPointerException();
                }
                boolean success = this.doRegisterRetryLatch(latch, this.version + 1L);
                if (success) break;
                String msg = MessageFormat.format("No retry is possible on transaction '%s' because it has no tracked reads, or not all reads are known (because it doesn't support automaticReadTracking) ", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new NoRetryPossibleException(msg);
            }
            case committed: {
                String commitMsg = MessageFormat.format("No retry is possible on already committed transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(commitMsg);
            }
            case aborted: {
                String abortedMsg = MessageFormat.format("No retry is possible on already aborted transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected boolean doRegisterRetryLatch(Latch latch, long wakeupVersion) {
        return false;
    }

    public final void startOr() {
        switch (this.status) {
            case active: {
                S snapshot = this.takeSnapshot();
                ((AbstractTransactionSnapshot)snapshot).parent = this.getSnapshot();
                ((AbstractTransactionSnapshot)snapshot).tasks = null;
                this.storeSnapshot(snapshot);
                break;
            }
            case committed: {
                String commitMsg = MessageFormat.format("Can't call startOr on already committed transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(commitMsg);
            }
            case aborted: {
                String abortMsg = MessageFormat.format("Can't call startOr on already aborted transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(abortMsg);
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public final void endOr() {
        switch (this.status) {
            case active: {
                S snapshot = this.getSnapshot();
                if (snapshot == null) {
                    throw new IllegalStateException();
                }
                this.storeSnapshot(((AbstractTransactionSnapshot)snapshot).parent);
                break;
            }
            case committed: {
                String committedMsg = MessageFormat.format("Can't call endOr on already committed transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case aborted: {
                String abortedMsg = MessageFormat.format("Can't call endOr on already aborted transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public final void endOrAndStartElse() {
        switch (this.status) {
            case active: {
                S snapshot = this.getSnapshot();
                if (snapshot == null) {
                    throw new IllegalStateException();
                }
                ((AbstractTransactionSnapshot)snapshot).restore();
                this.storeSnapshot(((AbstractTransactionSnapshot)snapshot).parent);
                break;
            }
            case committed: {
                String commitMsg = MessageFormat.format("Can't call endOrAndStartElse on already committed transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(commitMsg);
            }
            case aborted: {
                String abortMsg = MessageFormat.format("Can't call endOrAndStartElse on already aborted transaction '%s'", ((AbstractTransactionConfig)this.config).getFamilyName());
                throw new DeadTransactionException(abortMsg);
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    protected S takeSnapshot() {
        throw new UnsupportedOperationException();
    }

    protected S getSnapshot() {
        throw new UnsupportedOperationException();
    }

    protected void storeSnapshot(S snapshot) {
        throw new UnsupportedOperationException();
    }
}

