/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.TransactionLifecycleEvent;
import org.multiverse.api.TransactionLifecycleListener;
import org.multiverse.api.TransactionStatus;
import org.multiverse.api.exceptions.PanicError;
import org.multiverse.utils.latches.CheapLatch;

public abstract class TransactionTemplate<E> {
    private final boolean threadLocalAware;
    private final boolean lifecycleListenersEnabled;
    private final TransactionFactory txFactory;

    public TransactionTemplate() {
        this(GlobalStmInstance.getGlobalStmInstance());
    }

    public TransactionTemplate(Stm stm) {
        this(stm.getTransactionFactoryBuilder().setReadonly(false).setAutomaticReadTracking(true).build());
    }

    public TransactionTemplate(TransactionFactory txFactory) {
        this(txFactory, true, true);
    }

    public TransactionTemplate(TransactionFactory txFactory, boolean threadLocalAware, boolean lifecycleListenersEnabled) {
        if (txFactory == null) {
            throw new NullPointerException();
        }
        this.lifecycleListenersEnabled = lifecycleListenersEnabled;
        this.txFactory = txFactory;
        this.threadLocalAware = threadLocalAware;
    }

    public final boolean isThreadLocalAware() {
        return this.threadLocalAware;
    }

    public final boolean isLifecycleListenersEnabled() {
        return this.lifecycleListenersEnabled;
    }

    public final TransactionFactory getTransactionFactory() {
        return this.txFactory;
    }

    public abstract E execute(Transaction var1) throws Exception;

    protected void onInit() {
    }

    protected void onStart(Transaction tx) {
    }

    protected void onPreCommit(Transaction tx) {
    }

    protected void onPostCommit() {
    }

    protected void onPreAbort(Transaction tx) {
    }

    protected void onPostAbort() {
    }

    public final E execute() {
        try {
            return this.executeChecked();
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new InvisibleCheckedException(ex);
        }
    }

    public final E executeChecked() throws Exception {
        Transaction tx;
        Transaction transaction = tx = this.threadLocalAware ? ThreadLocalTransaction.getThreadLocalTransaction() : null;
        if (this.noActiveTransaction(tx)) {
            return this.executeWithTransaction();
        }
        return this.execute(tx);
    }

    /*
     * Exception decompiling
     */
    private E executeWithTransaction() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void awaitChangeAndRestart(Transaction tx) throws InterruptedException {
        CheapLatch latch = new CheapLatch();
        tx.registerRetryLatch(latch);
        tx.abort();
        if (tx.getConfig().isInterruptible()) {
            latch.await();
        } else {
            latch.awaitUninterruptible();
        }
        tx.restart();
    }

    private static void rethrow(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new PanicError("Unthrowable throwable", ex);
    }

    private boolean noActiveTransaction(Transaction t) {
        return t == null || t.getStatus() != TransactionStatus.active;
    }

    private class CallbackListener
    implements TransactionLifecycleListener {
        private CallbackListener() {
        }

        @Override
        public void notify(Transaction tx, TransactionLifecycleEvent event) {
            switch (event) {
                case preAbort: {
                    TransactionTemplate.this.onPreAbort(tx);
                    break;
                }
                case postAbort: {
                    TransactionTemplate.this.onPostAbort();
                    break;
                }
                case preCommit: {
                    TransactionTemplate.this.onPreCommit(tx);
                    break;
                }
                case postCommit: {
                    TransactionTemplate.this.onPostCommit();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static class InvisibleCheckedException
    extends RuntimeException {
        static final long serialVersionUID = 0L;

        public InvisibleCheckedException(Exception cause) {
            super(cause);
        }

        @Override
        public Exception getCause() {
            return (Exception)super.getCause();
        }
    }
}

