/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;
import org.multiverse.transactional.TransactionalReference;

@TransactionalObject
public final class DefaultTransactionalReference<E>
implements TransactionalReference<E> {
    private E reference;

    public DefaultTransactionalReference() {
        this(null);
    }

    public DefaultTransactionalReference(E reference) {
        this.reference = reference;
    }

    @Override
    @TransactionalMethod(readonly=true, automaticReadTracking=true)
    public E getOrAwait() {
        if (this.reference == null) {
            StmUtils.retry();
        }
        return this.reference;
    }

    @Override
    @TransactionalMethod(readonly=true, automaticReadTracking=true, interruptible=true)
    public E getOrAwaitInterruptibly() throws InterruptedException {
        if (this.reference == null) {
            StmUtils.retry();
        }
        return this.reference;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public boolean isNull() {
        return this.reference == null;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E get() {
        return this.reference;
    }

    @Override
    public E set(E newRef) {
        E oldRef = this.reference;
        this.reference = newRef;
        return oldRef;
    }

    @Override
    public E clear() {
        return this.set(null);
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        if (this.reference == null) {
            return "DefaultTransactionalReference(ref=null)";
        }
        return String.format("DefaultTransactionalReference(ref=%s)", this.reference);
    }
}

