/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.StmUtils;
import org.multiverse.utils.TodoException;

public abstract class AbstractBlockingDeque<E>
extends AbstractCollection<E>
implements BlockingDeque<E> {
    @Override
    @TransactionalMethod(interruptible=true)
    public boolean offerFirst(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod(interruptible=true)
    public boolean offerLast(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod
    public boolean addAll(Collection<? extends E> c) {
        return super.addAll(c);
    }

    @Override
    @TransactionalMethod
    public void addFirst(E e) {
        if (this.hasNoStorageCapacity()) {
            throw new IllegalStateException();
        }
        this.doAddFirst(e);
    }

    protected abstract void doAddFirst(E var1);

    @Override
    @TransactionalMethod
    public void addLast(E e) {
        if (this.hasNoStorageCapacity()) {
            throw new IllegalStateException();
        }
        this.doAddLast(e);
    }

    @Override
    @TransactionalMethod
    public boolean offerFirst(E e) {
        if (this.hasNoStorageCapacity()) {
            return false;
        }
        this.doAddFirst(e);
        return true;
    }

    @Override
    @TransactionalMethod
    public boolean offerLast(E e) {
        if (this.hasNoStorageCapacity()) {
            return false;
        }
        this.doAddLast(e);
        return true;
    }

    protected abstract void doAddLast(E var1);

    @Override
    @TransactionalMethod(interruptible=true)
    public void putFirst(E e) throws InterruptedException {
        if (this.hasNoStorageCapacity()) {
            StmUtils.retry();
        }
        this.doAddFirst(e);
    }

    @Override
    @TransactionalMethod(interruptible=true)
    public void putLast(E e) throws InterruptedException {
        if (this.hasNoStorageCapacity()) {
            StmUtils.retry();
        }
        this.doAddLast(e);
    }

    @Override
    @TransactionalMethod(interruptible=true)
    public E takeFirst() throws InterruptedException {
        if (this.isEmpty()) {
            StmUtils.retry();
        }
        return this.doRemoveFirst();
    }

    protected abstract E doRemoveFirst();

    @Override
    @TransactionalMethod(interruptible=true)
    public E takeLast() throws InterruptedException {
        if (this.isEmpty()) {
            StmUtils.retry();
        }
        return this.doRemoveLast();
    }

    protected abstract E doRemoveLast();

    @Override
    @TransactionalMethod
    public E removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.doRemoveFirst();
    }

    @Override
    @TransactionalMethod
    public E removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.doRemoveLast();
    }

    @Override
    @TransactionalMethod
    public boolean removeFirstOccurrence(Object o) {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod
    public boolean removeLastOccurrence(Object o) {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @TransactionalMethod
    protected boolean hasNoStorageCapacity() {
        return this.remainingCapacity() == 0;
    }

    @Override
    @TransactionalMethod
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    @TransactionalMethod
    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    @Override
    @TransactionalMethod
    public E remove() {
        return this.removeFirst();
    }

    @Override
    @TransactionalMethod
    public E poll() {
        return this.pollFirst();
    }

    @Override
    @TransactionalMethod
    public E pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.doRemoveFirst();
    }

    @Override
    @TransactionalMethod
    public E pollLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.doRemoveLast();
    }

    @Override
    @TransactionalMethod(interruptible=true)
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod(interruptible=true)
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod(interruptible=true)
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod(interruptible=true)
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod(interruptible=true)
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    @TransactionalMethod
    public E takeUninterruptible() {
        if (this.isEmpty()) {
            StmUtils.retry();
        }
        return this.doRemoveFirst();
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E element() {
        return this.getFirst();
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E peek() {
        return this.peekFirst();
    }

    @Override
    @TransactionalMethod
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    @TransactionalMethod
    public int drainTo(Collection<? super E> c) {
        if (this.isEmpty()) {
            return 0;
        }
        for (Object item : this) {
            c.add(item);
        }
        int oldSize = this.size();
        this.clear();
        return oldSize;
    }

    @Override
    @TransactionalMethod
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod
    public E pop() {
        return this.removeFirst();
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.peekFirst();
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E getLast() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.peekLast();
    }
}

