/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.StmUtils;
import org.multiverse.utils.TodoException;

public abstract class AbstractBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    protected abstract E doRemove();

    protected abstract void doAdd(E var1);

    protected abstract boolean isFull();

    @Override
    @TransactionalMethod
    public boolean offer(E e) {
        if (this.isFull()) {
            return false;
        }
        this.doAdd(e);
        return true;
    }

    @Override
    @TransactionalMethod
    public void put(E e) throws InterruptedException {
        if (this.isFull()) {
            StmUtils.retry();
        }
        this.doAdd(e);
    }

    @Override
    @TransactionalMethod
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod
    public E take() throws InterruptedException {
        if (this.isEmpty()) {
            StmUtils.retry();
        }
        return this.doRemove();
    }

    @Override
    @TransactionalMethod
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod
    public int drainTo(Collection<? super E> c) {
        int drainSize = this.size();
        if (drainSize == 0) {
            return 0;
        }
        for (Object item : this) {
            c.add(item);
        }
        return drainSize;
    }

    @Override
    @TransactionalMethod
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new TodoException();
    }

    @Override
    @TransactionalMethod
    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.doRemove();
    }
}

