/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.nonblocking;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.multiverse.api.Latch;
import org.multiverse.api.Transaction;
import org.multiverse.transactional.nonblocking.TransactionSelectionKey;
import org.multiverse.transactional.nonblocking.TransactionSelector;
import org.multiverse.utils.TodoException;

public class DefaultTransactionSelector<K extends TransactionSelectionKey>
implements TransactionSelector<K> {
    private final BlockingQueue<K> arrivedTasks;

    public DefaultTransactionSelector() {
        this(new LinkedBlockingQueue());
    }

    public DefaultTransactionSelector(BlockingQueue<K> arrivedTasks) {
        if (arrivedTasks == null) {
            throw new NullPointerException();
        }
        this.arrivedTasks = arrivedTasks;
    }

    @Override
    public void register(K task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Transaction tx = task.getTransaction();
        tx.registerRetryLatch(new NonBlockingLatch(this, task));
    }

    @Override
    public K select() throws InterruptedException {
        return (K)((TransactionSelectionKey)this.arrivedTasks.take());
    }

    @Override
    public K selectNow() {
        throw new TodoException();
    }

    @Override
    public void close() {
        throw new TodoException();
    }

    private static class NonBlockingLatch
    implements Latch {
        private final AtomicBoolean open = new AtomicBoolean();
        private final K context;
        final /* synthetic */ DefaultTransactionSelector this$0;

        public NonBlockingLatch(K context) {
            this.this$0 = var1_1;
            this.context = context;
        }

        @Override
        public void open() {
            if (this.open.compareAndSet(false, true)) {
                try {
                    this.this$0.arrivedTasks.put(this.context);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public boolean isOpen() {
            return this.open.get();
        }

        @Override
        public void await() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void awaitUninterruptible() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryAwait(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryAwaitUninterruptible(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }
    }
}

