/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.nonblocking;

import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.Transaction;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor;
import org.multiverse.transactional.nonblocking.DefaultTransactionSelector;
import org.multiverse.transactional.nonblocking.NonBlockingTask;
import org.multiverse.transactional.nonblocking.NonBlockingTransactionExecutor;
import org.multiverse.transactional.nonblocking.TransactionSelectionKey;
import org.multiverse.transactional.nonblocking.TransactionSelector;

@TransactionalObject
public class NonBlockingTaskThreadPoolExecutor
implements NonBlockingTransactionExecutor {
    private Thread[] workerThreads;
    private int threadCount;
    private TransactionSelector selector;
    private TransactionalThreadPoolExecutor executor;
    private State state;

    public NonBlockingTaskThreadPoolExecutor(int threadCount) {
        this(new DefaultTransactionSelector(), threadCount);
    }

    public NonBlockingTaskThreadPoolExecutor(TransactionSelector selector, int threadCount) {
        if (selector == null) {
            throw new NullPointerException();
        }
        this.threadCount = threadCount;
        this.selector = selector;
        this.state = State.unstarted;
        this.executor = new TransactionalThreadPoolExecutor(threadCount);
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    public void start() {
        this.executor.start();
    }

    public void shutdown() {
    }

    @Override
    public void execute(NonBlockingTask task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.selector.register(new Key(task));
    }

    static enum State {
        unstarted,
        started,
        shutdown,
        terminated;

    }

    static class SelectionKey
    implements TransactionSelectionKey {
        private final NonBlockingTask task;

        SelectionKey(NonBlockingTask task) {
            this.task = task;
        }

        @Override
        public Transaction getTransaction() {
            return null;
        }
    }

    public class Worker
    implements Runnable {
        @Override
        public void run() {
        }

        private void run(NonBlockingTask task) {
        }
    }

    class Key
    implements TransactionSelectionKey {
        private final NonBlockingTask task;

        Key(NonBlockingTask task) {
            this.task = task;
        }

        @Override
        public Transaction getTransaction() {
            return null;
        }
    }
}

