/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public class TransactionalBoolean {
    private boolean value;

    public TransactionalBoolean() {
        this(false);
    }

    public TransactionalBoolean(boolean value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public boolean get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, automaticReadTracking=true)
    public void await(boolean desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    public boolean set(boolean newValue) {
        boolean oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        if (this.value) {
            return "TransactionalBoolean(value=true)";
        }
        return "TransactionalBoolean(value=false)";
    }

    @TransactionalMethod(readonly=true)
    public int hashCode() {
        return this.value ? 1 : 0;
    }

    @TransactionalMethod(readonly=true)
    public boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof TransactionalBoolean)) {
            return false;
        }
        TransactionalBoolean that = (TransactionalBoolean)thatObj;
        return that.value == this.value;
    }
}

