/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public class TransactionalDouble {
    private double value;

    public TransactionalDouble() {
        this(0.0);
    }

    public TransactionalDouble(double value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public double get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, automaticReadTracking=true)
    public void await(double desired) {
        if (Double.doubleToLongBits(this.value) != Double.doubleToLongBits(desired)) {
            StmUtils.retry();
        }
    }

    public double set(double newValue) {
        double oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    public double inc() {
        this.value += 1.0;
        return this.value;
    }

    public double inc(double amount) {
        this.value += amount;
        return this.value;
    }

    public double dec() {
        this.value -= 1.0;
        return this.value;
    }

    public double dec(double amount) {
        this.value -= amount;
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        return String.format("TransactionalDouble(value=%s)", this.value);
    }

    @TransactionalMethod(readonly=true)
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    @TransactionalMethod(readonly=true)
    public boolean equals(Object thatobj) {
        if (thatobj == this) {
            return true;
        }
        if (!(thatobj instanceof TransactionalDouble)) {
            return false;
        }
        TransactionalDouble that = (TransactionalDouble)thatobj;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value);
    }
}

