/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public class TransactionalLong {
    private long value;

    public TransactionalLong() {
        this(0L);
    }

    public TransactionalLong(long value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public long get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, automaticReadTracking=true)
    public void await(long desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=true, automaticReadTracking=true)
    public long awaitLargerThan(long than) {
        if (this.value <= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, automaticReadTracking=true)
    public long awaitLargerOrEqualThan(long than) {
        if (this.value < than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, automaticReadTracking=true)
    public long awaitSmallerThan(long than) {
        if (this.value >= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, automaticReadTracking=true)
    public long awaitSmallerOrEqualThan(long than) {
        if (this.value > than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, automaticReadTracking=true)
    public long awaitNotEqualThan(long than) {
        if (this.value == than) {
            StmUtils.retry();
        }
        return this.value;
    }

    public long set(long newValue) {
        long oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    public long inc() {
        ++this.value;
        return this.value;
    }

    public long inc(long amount) {
        this.value += amount;
        return this.value;
    }

    public long dec() {
        --this.value;
        return this.value;
    }

    public long dec(long amount) {
        this.value -= amount;
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        return String.format("TransactionalLong(value=%s)", this.value);
    }

    @TransactionalMethod(readonly=true)
    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @TransactionalMethod(readonly=true)
    public boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof TransactionalLong)) {
            return false;
        }
        TransactionalLong that = (TransactionalLong)thatObj;
        return that.value == this.value;
    }
}

