/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils.backoff;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.multiverse.api.Transaction;
import org.multiverse.utils.backoff.BackoffPolicy;

public class ExponentialBackoffPolicy
implements BackoffPolicy {
    public static final ExponentialBackoffPolicy INSTANCE_10_MS_MAX = new ExponentialBackoffPolicy();
    private final long maxDelayNs;
    private final long minDelayNs;

    public ExponentialBackoffPolicy() {
        this(1000L, TimeUnit.MILLISECONDS.toNanos(10L), TimeUnit.NANOSECONDS);
    }

    public ExponentialBackoffPolicy(long minDelayNs, long maxDelay, TimeUnit unit) {
        this.maxDelayNs = unit.toNanos(maxDelay);
        this.minDelayNs = minDelayNs;
        if (minDelayNs > this.maxDelayNs) {
            throw new IllegalArgumentException("minimum delay can't be larger than maximum delay");
        }
    }

    public long getMaxDelayNs() {
        return this.maxDelayNs;
    }

    public long getMinDelayNs() {
        return this.minDelayNs;
    }

    @Override
    public void delay(Transaction t, int attempt) throws InterruptedException {
        this.delayedUninterruptible(t, attempt);
    }

    @Override
    public void delayedUninterruptible(Transaction t, int attempt) {
        long delayNs = this.calcDelayNs(attempt);
        LockSupport.parkNanos(delayNs);
    }

    protected long calcDelayNs(int attempt) {
        long delayNs = attempt <= 0 ? 0L : (attempt >= 63 ? Long.MAX_VALUE : 1L << attempt);
        if (this.minDelayNs > 0L && delayNs < this.minDelayNs) {
            delayNs = this.minDelayNs;
        }
        if (this.maxDelayNs > 0L && delayNs > this.maxDelayNs) {
            delayNs = this.maxDelayNs;
        }
        return delayNs;
    }
}

