/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.utils.StandardThreadFactory;

public class StandardThreadFactory_createTest {
    @Test
    public void testArguments() {
        StandardThreadFactory factory = new StandardThreadFactory();
        try {
            factory.newThread(null);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ex) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testPriorityIsHigherThanThreadgroupAllows() {
        ThreadGroup threadGroup = new ThreadGroup("somename");
        threadGroup.setMaxPriority(10);
        StandardThreadFactory factory = new StandardThreadFactory(10, threadGroup);
        threadGroup.setMaxPriority(9);
        Runnable task = new Runnable(){

            @Override
            public void run() {
            }
        };
        factory.newThread(task);
    }

    @Test
    public void testSuccess() {
        ThreadGroup group = new ThreadGroup("somename");
        int priority = 10;
        StandardThreadFactory factory = new StandardThreadFactory(priority, group);
        Runnable task = new Runnable(){

            @Override
            public void run() {
            }
        };
        Thread t = factory.newThread(task);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((long)priority, (long)t.getPriority());
        Assert.assertSame((Object)group, (Object)t.getThreadGroup());
        Assert.assertEquals((Object)((Object)Thread.State.NEW), (Object)((Object)t.getState()));
        Assert.assertFalse((boolean)t.isDaemon());
    }
}

