/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.TransactionStatus;
import org.multiverse.api.backoff.BackoffPolicy;
import org.multiverse.api.exceptions.ControlFlowError;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.api.exceptions.RetryTimeoutException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.api.latches.StandardLatch;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;

public abstract class TransactionTemplate<E> {
    private final boolean threadLocalAware;
    private final boolean lifecycleListenersEnabled;
    private final TransactionFactory txFactory;

    public TransactionTemplate() {
        this(GlobalStmInstance.getGlobalStmInstance());
    }

    public TransactionTemplate(Stm stm) {
        this(stm.getTransactionFactoryBuilder().build());
    }

    public TransactionTemplate(TransactionFactory txFactory) {
        this(txFactory, true, true, true);
    }

    public TransactionTemplate(TransactionFactory txFactory, boolean threadLocalAware, boolean lifecycleListenersEnabled, boolean retryEnabled) {
        if (txFactory == null) {
            throw new NullPointerException();
        }
        this.lifecycleListenersEnabled = lifecycleListenersEnabled;
        this.txFactory = txFactory;
        this.threadLocalAware = threadLocalAware;
    }

    public final boolean isThreadLocalAware() {
        return this.threadLocalAware;
    }

    public final boolean isLifecycleListenersEnabled() {
        return this.lifecycleListenersEnabled;
    }

    public final TransactionFactory getTransactionFactory() {
        return this.txFactory;
    }

    public abstract E execute(Transaction var1) throws Exception;

    protected void onInit() {
    }

    protected void onStart(Transaction tx) {
    }

    protected void onPreCommit(Transaction tx) {
    }

    protected void onPostCommit() {
    }

    protected void onPreAbort(Transaction tx) {
    }

    protected void onPostAbort() {
    }

    public final E execute() {
        try {
            return this.executeChecked();
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new InvisibleCheckedException(ex);
        }
    }

    public final E executeChecked() throws Exception {
        Transaction tx;
        Transaction transaction = tx = this.threadLocalAware ? ThreadLocalTransaction.getThreadLocalTransaction() : null;
        if (this.noActiveTransaction(tx)) {
            return this.executeWithTransaction();
        }
        return this.execute(tx);
    }

    private E executeWithTransaction() throws Exception {
        CallbackListener listener = this.lifecycleListenersEnabled ? new CallbackListener() : null;
        Object tx = this.txFactory.start();
        if (this.threadLocalAware) {
            ThreadLocalTransaction.setThreadLocalTransaction(tx);
        }
        Throwable lastFailureCause = null;
        if (this.lifecycleListenersEnabled) {
            this.onInit();
        }
        while (true) {
            E e;
            tx.setAttempt(tx.getAttempt() + 1);
            try {
                if (listener != null) {
                    tx.registerLifecycleListener(listener);
                }
                this.onStart((Transaction)tx);
                E result = this.execute((Transaction)tx);
                tx.commit();
                e = result;
            }
            catch (Retry e2) {
                try {
                    this.handleRetry((Transaction)tx);
                    continue;
                }
                catch (SpeculativeConfigurationFailure ex) {
                    tx = this.handleSpeculativeConfigurationFailure((Transaction)tx);
                    continue;
                }
                catch (ControlFlowError er) {
                    this.handleControlFlowError((Transaction)tx);
                }
                if (tx.getAttempt() - 1 < tx.getConfiguration().getMaxRetries()) continue;
                String msg = String.format("Too many retries on transaction '%s', maxRetries = %s", tx.getConfiguration().getFamilyName(), tx.getConfiguration().getMaxRetries());
                throw new TooManyRetriesException(msg, lastFailureCause);
            }
            return e;
            break;
        }
        finally {
            if (tx != null && tx.getStatus() != TransactionStatus.committed) {
                tx.abort();
            }
            if (this.threadLocalAware) {
                ThreadLocalTransaction.setThreadLocalTransaction(null);
            }
        }
    }

    private void handleControlFlowError(Transaction tx) {
        BackoffPolicy backoffPolicy = tx.getConfiguration().getBackoffPolicy();
        backoffPolicy.delayedUninterruptible(tx);
        tx.restart();
    }

    private void handleRetry(Transaction tx) throws InterruptedException {
        if (tx.getAttempt() - 1 < tx.getConfiguration().getMaxRetries()) {
            Latch latch = tx.getRemainingTimeoutNs() == Long.MAX_VALUE ? new CheapLatch() : new StandardLatch();
            tx.registerRetryLatch(latch);
            tx.abort();
            if (tx.getRemainingTimeoutNs() == Long.MAX_VALUE) {
                if (tx.getConfiguration().isInterruptible()) {
                    latch.await();
                } else {
                    latch.awaitUninterruptible();
                }
            } else {
                long beginNs = System.nanoTime();
                boolean timeout = tx.getConfiguration().isInterruptible() ? !latch.tryAwaitNs(tx.getRemainingTimeoutNs()) : !latch.tryAwaitNs(tx.getRemainingTimeoutNs());
                long durationNs = beginNs - System.nanoTime();
                tx.setRemainingTimeoutNs(tx.getRemainingTimeoutNs() - durationNs);
                if (timeout) {
                    String msg = String.format("Transaction %s has timed with a total timeout of %s ns", tx.getConfiguration().getFamilyName(), tx.getConfiguration().getTimeoutNs());
                    throw new RetryTimeoutException(msg);
                }
            }
            tx.restart();
        }
    }

    private Transaction handleSpeculativeConfigurationFailure(Transaction oldTx) {
        oldTx.abort();
        Object newTx = this.txFactory.start();
        newTx.setAttempt(oldTx.getAttempt());
        newTx.setRemainingTimeoutNs(oldTx.getRemainingTimeoutNs());
        if (this.threadLocalAware) {
            ThreadLocalTransaction.setThreadLocalTransaction(newTx);
        }
        return newTx;
    }

    private boolean noActiveTransaction(Transaction t) {
        return t == null || t.getStatus() != TransactionStatus.active;
    }

    private class CallbackListener
    implements TransactionLifecycleListener {
        private CallbackListener() {
        }

        @Override
        public void notify(Transaction tx, TransactionLifecycleEvent event) {
            switch (event) {
                case preAbort: {
                    TransactionTemplate.this.onPreAbort(tx);
                    break;
                }
                case postAbort: {
                    TransactionTemplate.this.onPostAbort();
                    break;
                }
                case preCommit: {
                    TransactionTemplate.this.onPreCommit(tx);
                    break;
                }
                case postCommit: {
                    TransactionTemplate.this.onPostCommit();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static class InvisibleCheckedException
    extends RuntimeException {
        static final long serialVersionUID = 0L;

        public InvisibleCheckedException(Exception cause) {
            super(cause);
        }

        @Override
        public Exception getCause() {
            return (Exception)super.getCause();
        }
    }
}

