/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;
import org.multiverse.transactional.TransactionalReference;

@TransactionalObject
public final class TransactionalAbaReference<E>
implements TransactionalReference<E> {
    private E reference;
    private long writeVersion;

    public TransactionalAbaReference() {
        this.reference = null;
        this.writeVersion = Long.MIN_VALUE;
    }

    public TransactionalAbaReference(E reference) {
        this.reference = reference;
        this.writeVersion = Long.MIN_VALUE;
    }

    @Override
    @TransactionalMethod(readonly=true, trackReads=true)
    public E getOrAwait() {
        if (this.reference == null) {
            StmUtils.retry();
        }
        return this.reference;
    }

    @Override
    @TransactionalMethod(readonly=true, trackReads=true, interruptible=true)
    public E getOrAwaitInterruptibly() throws InterruptedException {
        if (this.reference == null) {
            StmUtils.retry();
        }
        return this.reference;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E get() {
        return this.reference;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public boolean isNull() {
        return this.reference == null;
    }

    @Override
    public E set(E newRef) {
        if (newRef != this.reference) {
            E oldRef = this.reference;
            this.reference = newRef;
            ++this.writeVersion;
            return oldRef;
        }
        return newRef;
    }

    @Override
    public E clear() {
        return this.set(null);
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        if (this.reference == null) {
            return "TransactionalAbaReference(ref=null)";
        }
        return String.format("TransactionalAbaReference(ref=%s)", this.reference);
    }
}

