/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public final class TransactionalFloat {
    private float value;

    public TransactionalFloat() {
        this(0.0f);
    }

    public TransactionalFloat(float value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public float get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public void await(char desired) {
        if (Float.floatToIntBits(this.value) != Float.floatToIntBits(desired)) {
            StmUtils.retry();
        }
    }

    public float set(float newValue) {
        float oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    public float inc() {
        this.value += 1.0f;
        return this.value;
    }

    public float inc(float amount) {
        this.value += amount;
        return this.value;
    }

    public float dec() {
        this.value -= 1.0f;
        return this.value;
    }

    public float dec(float amount) {
        this.value -= amount;
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        return String.format("TransactionalFloat(value=%s)", Float.valueOf(this.value));
    }

    @TransactionalMethod(readonly=true)
    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @TransactionalMethod(readonly=true)
    public boolean equals(Object thatobj) {
        if (thatobj == this) {
            return true;
        }
        if (!(thatobj instanceof TransactionalFloat)) {
            return false;
        }
        TransactionalFloat that = (TransactionalFloat)thatobj;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(that.value);
    }
}

