/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.stms.AbstractTransaction;
import org.multiverse.stms.AbstractTransactionImpl;

public class AbstractTransaction_prepareTest {
    @Test
    public void whenLifecycleListenerRegistered_thenPreCommitIsCalled() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        tx.prepare();
        TestUtils.assertIsPrepared(new Transaction[]{tx});
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.preCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)tx, TransactionLifecycleEvent.postCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
    }

    @Test
    public void whenPreCommitTaskFails_thenAborted() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        RuntimeException expected = new RuntimeException();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)expected).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.preCommit);
        try {
            tx.prepare();
            Assert.fail();
        }
        catch (Exception found) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
        ((AbstractTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)1))).doAbortPrepared();
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.preCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)tx, TransactionLifecycleEvent.postCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.preAbort);
    }

    @Test
    public void whenExceptionThrown_thenAbort() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        RuntimeException expected = new RuntimeException();
        ((AbstractTransaction)Mockito.doThrow((Throwable)expected).when((Object)tx)).doPrepare();
        try {
            tx.prepare();
            Assert.fail();
        }
        catch (Exception found) {
            Assert.assertSame((Object)expected, (Object)found);
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenAlreadyPrepared_callIgnored() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        tx.prepare();
        Mockito.reset((Object[])new AbstractTransaction[]{tx});
        tx.prepare();
        ((AbstractTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)0))).doPrepare();
        TestUtils.assertIsPrepared(new Transaction[]{tx});
    }

    @Test
    public void whenAlreadyPrepared_noLifecycleListenersCalled() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        tx.prepare();
        Mockito.reset((Object[])new TransactionLifecycleListener[]{listener});
        tx.prepare();
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)Mockito.any(), (TransactionLifecycleEvent)Mockito.any());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        tx.abort();
        try {
            tx.prepare();
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
        ((AbstractTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)0))).doPrepare();
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        tx.commit();
        Mockito.reset((Object[])new AbstractTransaction[]{tx});
        try {
            tx.prepare();
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted(new Transaction[]{tx});
        ((AbstractTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)0))).doPrepare();
    }
}

