/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;

public final class StmUtils {
    public static void retry() {
        ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        throw Retry.create();
    }

    public static void prepare() {
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.prepare();
    }

    public static void abort() {
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.abort();
    }

    public static void commit() {
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.commit();
    }

    public static void scheduleDeferredTask(final Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.registerLifecycleListener(new TransactionLifecycleListener(){

            @Override
            public void notify(Transaction tx, TransactionLifecycleEvent event) {
                if (event == TransactionLifecycleEvent.postCommit) {
                    task.run();
                }
            }
        });
    }

    public static void scheduleCompensatingTask(final Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Transaction tx = ThreadLocalTransaction.getRequiredThreadLocalTransaction();
        tx.registerLifecycleListener(new TransactionLifecycleListener(){

            @Override
            public void notify(Transaction tx, TransactionLifecycleEvent event) {
                if (event == TransactionLifecycleEvent.postAbort) {
                    task.run();
                }
            }
        });
    }

    private StmUtils() {
    }
}

