/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.clock;

import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.api.clock.PrimitiveClock;

public final class StrictPrimitiveClock
implements PrimitiveClock {
    private final AtomicLong clock = new AtomicLong();

    public StrictPrimitiveClock() {
    }

    public StrictPrimitiveClock(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        this.clock.set(time);
    }

    @Override
    public long strictTick() {
        return this.tick();
    }

    @Override
    public long tick() {
        return this.clock.incrementAndGet();
    }

    @Override
    public long getVersion() {
        return this.clock.get();
    }

    public String toString() {
        return String.format("StrictPrimitiveClock(time=%s)", this.clock.get());
    }
}

