/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import org.multiverse.annotations.NonTransactional;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.programmatic.ProgrammaticReference;
import org.multiverse.api.programmatic.ProgrammaticReferenceFactory;

@TransactionalObject
public final class TransactionalReferenceArray<E> {
    private static final ProgrammaticReferenceFactory referenceFactory = GlobalStmInstance.getGlobalStmInstance().getProgrammaticReferenceFactoryBuilder().build();
    private final ProgrammaticReference<E>[] array;

    public TransactionalReferenceArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.array = new ProgrammaticReference[length];
        for (int k = 0; k < length; ++k) {
            this.array[k] = referenceFactory.atomicCreateReference(null);
        }
    }

    private TransactionalReferenceArray(ProgrammaticReference<E>[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        this.array = array;
    }

    @TransactionalMethod(readonly=true)
    public E get(int index) {
        return this.array[index].get();
    }

    @NonTransactional
    public E atomicGet(int index) {
        return this.array[index].atomicGet();
    }

    public E set(int index, E item) {
        return this.array[index].set(item);
    }

    @NonTransactional
    public E atomicSet(int index, E update) {
        return this.array[index].atomicSet(update);
    }

    @NonTransactional
    public boolean atomicCompareAndSet(int index, E expected, E update) {
        return this.array[index].atomicCompareAndSet(expected, update);
    }

    @NonTransactional
    public int length() {
        return this.array.length;
    }

    public void shiftLeft(int firstIndex, int lastIndex) {
        if (firstIndex < 1 || firstIndex >= this.array.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int k = firstIndex; k <= lastIndex; ++k) {
            E right = this.array[k].get();
            this.array[k - 1].set(right);
        }
        this.array[lastIndex].set(null);
    }

    public void shiftRight(int firstIndex, int lastIndex) {
        if (firstIndex < 0 || firstIndex >= this.array.length - 1) {
            throw new IndexOutOfBoundsException();
        }
        for (int k = lastIndex; k >= firstIndex; --k) {
            E left = this.array[k].get();
            this.array[k + 1].set(left);
        }
        this.array[firstIndex].set(null);
    }

    public TransactionalReferenceArray<E> copyToBiggerArray(int newLength) {
        if (newLength < this.array.length) {
            throw new IllegalArgumentException();
        }
        ProgrammaticReference[] newArray = new ProgrammaticReference[newLength];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        for (int k = this.array.length; k < newLength; ++k) {
            newArray[k] = referenceFactory.atomicCreateReference(null);
        }
        return new TransactionalReferenceArray<E>(newArray);
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        int length = this.length();
        if (length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer("[");
        for (int k = 0; k < length; ++k) {
            sb.append(this.array[k].get());
            if (k >= length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @TransactionalMethod(readonly=true)
    public Object[] toArray(int size) {
        if (size < 0 || size > this.array.length) {
            throw new IllegalArgumentException();
        }
        Object[] result = new Object[size];
        for (int k = 0; k < size; ++k) {
            result[k] = this.array[k].get();
        }
        return result;
    }
}

