/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.multiverse.annotations.FieldGranularity;
import org.multiverse.annotations.NonTransactional;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.programmatic.ProgrammaticLong;
import org.multiverse.api.programmatic.ProgrammaticReferenceFactory;
import org.multiverse.transactional.collections.AbstractTransactionalDeque;
import org.multiverse.transactional.collections.TransactionalList;
import org.multiverse.utils.TodoException;

@TransactionalObject
public final class TransactionalLinkedList<E>
extends AbstractTransactionalDeque<E>
implements TransactionalList<E> {
    private static final ProgrammaticReferenceFactory sizeFactory = GlobalStmInstance.getGlobalStmInstance().getProgrammaticReferenceFactoryBuilder().build();
    private final int maxCapacity;
    private final boolean relaxedMaximumCapacity;
    private final ProgrammaticLong size;
    @FieldGranularity
    private Node<E> head;
    @FieldGranularity
    private Node<E> tail;

    public TransactionalLinkedList() {
        this(Integer.MAX_VALUE);
    }

    public TransactionalLinkedList(E ... items) {
        this(Integer.MAX_VALUE);
        if (items == null) {
            throw new NullPointerException();
        }
        for (E item : items) {
            this.add(item);
        }
    }

    public TransactionalLinkedList(Collection<E> items) {
        this(Integer.MAX_VALUE);
        if (items == null) {
            throw new NullPointerException();
        }
        if (items.isEmpty()) {
            return;
        }
        for (E item : items) {
            this.add(item);
        }
    }

    public TransactionalLinkedList(int maxCapacity) {
        this(maxCapacity, false);
    }

    public TransactionalLinkedList(int maxCapacity, boolean relaxedMaximumCapacity) {
        if (maxCapacity < 0) {
            throw new IllegalArgumentException("maxCapacity can't be smaller than 0");
        }
        this.relaxedMaximumCapacity = relaxedMaximumCapacity;
        this.maxCapacity = maxCapacity;
        this.size = sizeFactory.atomicCreateLong(0L);
    }

    @NonTransactional
    public boolean hasRelaxedMaxCapacity() {
        return this.relaxedMaximumCapacity;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    @NonTransactional
    public int atomicSize() {
        return (int)this.size.atomicGet();
    }

    @Override
    @TransactionalMethod(readonly=true, trackReads=false)
    public int size() {
        return (int)this.size.get();
    }

    @Override
    @TransactionalMethod(readonly=true)
    public int remainingCapacity() {
        if (this.relaxedMaximumCapacity) {
            return Math.max(0, this.maxCapacity - (int)this.size.atomicGet());
        }
        return Math.max(0, this.maxCapacity - (int)this.size.get());
    }

    @Override
    public void clear() {
        if (this.head == null) {
            return;
        }
        this.size.set(0L);
        this.head = null;
        this.tail = null;
    }

    @TransactionalMethod(readonly=true)
    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    @Override
    protected void doAddLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> newNode = new Node<E>(e);
        if (this.head == null) {
            this.head = newNode;
            this.tail = newNode;
        } else {
            this.tail.next = newNode;
            newNode.prev = this.tail;
            this.tail = newNode;
        }
        this.size.commutingInc(1L);
    }

    @Override
    protected void doAddFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        if (this.head == null) {
            this.head = node;
            this.tail = node;
        } else {
            this.head.prev = node;
            node.next = this.head;
            this.head = node;
        }
        this.size.commutingInc(1L);
    }

    public Node<E> getHead() {
        return this.head;
    }

    @Override
    public E removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object value = this.head.value;
        if (this.head.next == null) {
            this.head = null;
            this.tail = null;
        } else {
            this.head.next.prev = null;
            this.head = this.head.next;
        }
        this.size.commutingInc(-1L);
        return value;
    }

    @Override
    protected E doRemoveFirst() {
        Object value = this.head.value;
        if (this.head.next == null) {
            this.head = null;
            this.tail = null;
        } else {
            this.head.next.prev = null;
            this.head = this.head.next;
        }
        this.size.commutingInc(-1L);
        return value;
    }

    @Override
    public E takeLast() throws InterruptedException {
        if (this.head == null) {
            StmUtils.retry();
        }
        return this.doRemoveLast();
    }

    @Override
    @TransactionalMethod(trackReads=true)
    public void putFirst(E e) throws InterruptedException {
        if (this.hasNoStorageCapacity()) {
            this.size();
            StmUtils.retry();
        }
        this.doAddFirst(e);
    }

    @Override
    protected E doRemoveLast() {
        Object value = this.tail.value;
        if (this.head.next == null) {
            this.head = null;
            this.tail = null;
        } else {
            this.tail.prev.next = null;
            this.tail = this.tail.prev;
        }
        this.size.commutingInc(-1L);
        return value;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl(this.head);
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E peekFirst() {
        return this.head == null ? null : (E)this.head.value;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E peekLast() {
        return this.tail == null ? null : (E)this.tail.value;
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIteratorImpl(this.tail);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E get(int index) {
        if (index < 0 || (long)index >= this.size.get()) {
            throw new IndexOutOfBoundsException();
        }
        return this.getNode((int)index).value;
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 || (long)index >= this.size.get()) {
            throw new IndexOutOfBoundsException();
        }
        if (element == null) {
            throw new NullPointerException();
        }
        Node<E> node = this.getNode(index);
        Object old = node.value;
        node.value = element;
        return old;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @TransactionalMethod
    public boolean addAll(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        for (E item : c) {
            if (!this.add(item)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public E remove(int index) {
        if (index < 0 || (long)index >= this.size.get()) {
            throw new IndexOutOfBoundsException();
        }
        Node<E> node = this.getNode(index);
        this.remove(node);
        return node.value;
    }

    private Node<E> getNode(int index) {
        Node<E> node;
        if ((long)index < this.size.get() / 2L) {
            node = this.head;
            for (int k = 0; k < index; ++k) {
                node = node.next;
            }
        } else {
            node = this.tail;
            for (int k = (int)this.size.get() - 1; k > index; --k) {
                node = node.prev;
            }
        }
        return node;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public int indexOf(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int index = 0;
        Node<E> node = this.head;
        while (node != null) {
            if (node.value.equals(o)) {
                return index;
            }
            ++index;
            node = node.next;
        }
        return -1;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public int lastIndexOf(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int index = (int)this.size.get() - 1;
        Node<E> node = this.tail;
        while (node != null) {
            if (node.value.equals(o)) {
                return index;
            }
            --index;
            node = node.prev;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || (long)index >= this.size.get()) {
            throw new IndexOutOfBoundsException();
        }
        return new ListIteratorImpl(index, this.getNode(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object item) {
        Node<E> found = this.findNode(item);
        if (found == null) {
            return false;
        }
        this.removeNode(found);
        return true;
    }

    private void removeNode(Node<E> node) {
        this.size.commutingInc(-1L);
        if (node == this.head) {
            this.head = node.next;
        }
        if (node == this.tail) {
            this.tail = node.prev;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        }
        if (node.prev != null) {
            node.prev.next = node.next;
        }
    }

    private Node<E> findNode(Object value) {
        Node<E> node = this.head;
        while (node != null) {
            if (node.value == null ? value == null : node.value.equals(value)) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof List)) {
            return false;
        }
        List that = (List)thatObj;
        if (that.size() != this.size()) {
            return false;
        }
        ListIterator<E> thisIt = this.listIterator();
        ListIterator thatIt = that.listIterator();
        while (thisIt.hasNext() && thatIt.hasNext()) {
            E thisItem = thisIt.next();
            Object thatItem = thatIt.next();
            if (thisItem != null ? thisItem.equals(thatItem) : thatItem == null) continue;
            return false;
        }
        return !thisIt.hasNext() && !thatIt.hasNext();
    }

    @TransactionalObject
    public static final class Node<E> {
        public Node<E> next;
        public Node<E> prev;
        public E value;

        public Node(E value) {
            this.value = value;
        }
    }

    @TransactionalObject
    public final class DescendingIteratorImpl
    implements Iterator<E> {
        private Node<E> previous;
        private Node<E> current = null;

        private DescendingIteratorImpl(Node<E> tail) {
            this.previous = tail;
        }

        @Override
        @TransactionalMethod(readonly=true)
        public boolean hasNext() {
            return this.previous != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.previous;
            this.previous = this.previous.prev;
            return this.current.value;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            TransactionalLinkedList.this.removeNode(this.current);
        }
    }

    @TransactionalObject
    public class IteratorImpl
    implements Iterator<E> {
        private Node<E> next;
        private Node<E> current = null;

        private IteratorImpl(Node<E> head) {
            this.next = head;
        }

        @Override
        @TransactionalMethod(readonly=true)
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = this.next.next;
            return this.current.value;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            TransactionalLinkedList.this.removeNode(this.current);
        }
    }

    @TransactionalObject
    public class ListIteratorImpl
    implements ListIterator<E> {
        private int index;
        private Node<E> node;

        public ListIteratorImpl(int index, Node<E> node) {
            this.index = index;
            this.node = node;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object value = this.node.value;
            this.node = this.node.next;
            return value;
        }

        @Override
        public boolean hasPrevious() {
            return this.node.prev != null;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object value = this.node.value;
            this.node = this.node.prev;
            return value;
        }

        @Override
        public int nextIndex() {
            throw new TodoException();
        }

        @Override
        public int previousIndex() {
            throw new TodoException();
        }

        @Override
        public void remove() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            TransactionalLinkedList.this.removeNode(this.node);
        }

        @Override
        public void set(E e) {
            throw new TodoException();
        }

        @Override
        public void add(E e) {
            throw new TodoException();
        }
    }
}

