/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public final class TransactionalByte {
    private byte value;

    public TransactionalByte() {
        this(0);
    }

    public TransactionalByte(byte value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public byte get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public void await(byte desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public byte awaitLargerThan(byte than) {
        if (this.value <= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public byte awaitLargerOrEqualThan(byte than) {
        if (this.value < than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public byte awaitSmallerThan(byte than) {
        if (this.value >= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public byte awaitSmallerOrEqualThan(byte than) {
        if (this.value > than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public byte awaitNotEqualTo(byte than) {
        if (this.value == than) {
            StmUtils.retry();
        }
        return this.value;
    }

    public byte set(byte newValue) {
        byte oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    public byte inc() {
        this.value = (byte)(this.value + 1);
        return this.value;
    }

    public byte inc(byte amount) {
        this.value = (byte)(this.value + amount);
        return this.value;
    }

    public byte dec() {
        this.value = (byte)(this.value - 1);
        return this.value;
    }

    public byte dec(byte amount) {
        this.value = (byte)(this.value - amount);
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        return String.format("TransactionalByte(value=%s)", this.value);
    }

    @TransactionalMethod(readonly=true)
    public int hashCode() {
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof TransactionalByte)) {
            return false;
        }
        TransactionalByte that = (TransactionalByte)thatObj;
        return that.value == this.value;
    }
}

