/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public final class TransactionalCharacter {
    private char value;

    public TransactionalCharacter() {
        this('\u0000');
    }

    public TransactionalCharacter(char value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public char get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public void await(char desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public char awaitLargerThan(char than) {
        if (this.value <= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public char awaitLargerOrEqualThan(char than) {
        if (this.value < than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public char awaitSmallerThan(char than) {
        if (this.value >= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public char awaitSmallerOrEqualThan(char than) {
        if (this.value > than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public char awaitNotEqualTo(char than) {
        if (this.value == than) {
            StmUtils.retry();
        }
        return this.value;
    }

    public char set(char newValue) {
        char oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    public char inc() {
        this.value = (char)(this.value + '\u0001');
        return this.value;
    }

    public char inc(char amount) {
        this.value = (char)(this.value + amount);
        return this.value;
    }

    public char dec() {
        this.value = (char)(this.value - '\u0001');
        return this.value;
    }

    public char dec(char amount) {
        this.value = (char)(this.value - amount);
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        return String.format("TransactionalCharacter(value=%s)", Character.valueOf(this.value));
    }

    @TransactionalMethod(readonly=true)
    public int hashCode() {
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof TransactionalCharacter)) {
            return false;
        }
        TransactionalCharacter that = (TransactionalCharacter)thatObj;
        return that.value == this.value;
    }
}

